<?php // $file = /home/hmcadminuser/public_html/wp-content/themes/yootheme/vendor/yootheme/theme-wordpress/config/customizer.json

return [
  'sections' => [
    'layout' => [
      'help' => [
        'Customizer' => [[
            'title' => 'Using the Sidebar', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=MM3FRptp9yk&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:51', 
            'documentation' => 'support/yootheme-pro/wordpress/customizer#save,-cancel-and-close', 
            'support' => 'support/search?tags=125&q=customizer%20save'
          ], [
            'title' => 'Using the Contextual Help', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=EF8pQklT-Kc&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:39', 
            'documentation' => 'support/yootheme-pro/wordpress/customizer#contextual-help', 
            'support' => 'support/search?tags=125&q=contextual%20help'
          ], [
            'title' => 'Using the Device Preview Buttons', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=zg8H6wRX8b0&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:26', 
            'documentation' => 'support/yootheme-pro/wordpress/customizer#device-preview-buttons', 
            'support' => 'support/search?tags=125&q=customizer%20device%20preview'
          ], [
            'title' => 'Hide the Sidebar', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=RM4jQ7bMonE&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:23', 
            'documentation' => 'support/yootheme-pro/wordpress/customizer#hide-sidebar', 
            'support' => 'support/search?tags=125&q=customizer%20hide%%20sidebar'
          ]], 
        'Widgets and Areas' => [[
            'title' => 'Managing Widgets', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=VPvMOJy8hPA&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:19', 
            'documentation' => 'support/yootheme-pro/wordpress/widgets-and-modules', 
            'support' => 'support/search?tags=125&q=widgets'
          ], [
            'title' => 'Creating a New Widget', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=O16xubfMVIc&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:41', 
            'documentation' => 'support/yootheme-pro/wordpress/widgets-and-modules#widget-customizer', 
            'support' => 'support/search?tags=125&q=widgets'
          ], [
            'title' => 'Using Widget Areas', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=BMgIa3f8E9I&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:59', 
            'documentation' => 'support/yootheme-pro/wordpress/widgets-and-modules#widget-areas', 
            'support' => 'support/search?tags=125&q=module%20areas'
          ], [
            'title' => 'Assigning Widgets to Specific Pages', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=wISfqKacK_I&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:20', 
            'documentation' => 'support/yootheme-pro/wordpress/widget-and-module-settings#widget-visibility', 
            'support' => 'support/search?tags=125&q=widget%20visibility'
          ]], 
        'Widget Theme Settings' => [[
            'title' => 'Setting the Widget Default Options', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=ztNQJfh6z4k&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:36', 
            'documentation' => 'support/yootheme-pro/wordpress/widget-and-module-settings#default-options', 
            'support' => 'support/search?tags=125&q=widget%20theme%20settings'
          ], [
            'title' => 'Setting the Widget Appearance Options', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=YzRyi1mUiuY&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:52', 
            'documentation' => 'support/yootheme-pro/wordpress/widget-and-module-settings#appearance-options', 
            'support' => 'support/search?tags=125&q=widget%20theme%20settings'
          ], [
            'title' => 'Setting the Widget Grid Options', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=Be0hS6ypIIs&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:22', 
            'documentation' => 'support/yootheme-pro/wordpress/widget-and-module-settings#grid-options', 
            'support' => 'support/search?tags=125&q=widget%20theme%20settings%20grid'
          ], [
            'title' => 'Setting the Widget List Options', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=ojxI4oZga4Q&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:31', 
            'documentation' => 'support/yootheme-pro/wordpress/widget-and-module-settings#list-options', 
            'support' => 'support/search?tags=125&q=widget%20theme%20settings%20list'
          ], [
            'title' => 'Setting the Widget Menu Options', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=btOduHgXEEU&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:27', 
            'documentation' => 'support/yootheme-pro/wordpress/widget-and-module-settings#menu-options', 
            'support' => 'support/search?tags=125&q=widget%20theme%20settings%20menu'
          ]], 
        'Builder Widget' => [[
            'title' => 'Open the Builder Widget', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=JL7gkNxBS-c&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:13', 
            'documentation' => 'support/yootheme-pro/wordpress/builder-widget-and-module', 
            'support' => 'support/search?tags=125&q=builder%20widget'
          ], [
            'title' => 'Creating Advanced Widget Layouts', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=CErGPHexytc&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '4:19', 
            'documentation' => 'support/yootheme-pro/wordpress/builder-widget-and-module#advanced-layouts', 
            'support' => 'support/search?tags=125&q=builder%20widget'
          ]], 
        'Menus' => [[
            'title' => 'Managing Menus', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=-hdWMCNhjZs&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:58', 
            'documentation' => 'support/yootheme-pro/wordpress/menus', 
            'support' => 'support/search?tags=125&q=menu'
          ], [
            'title' => 'Using Menu Locations', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=gBIqbfbm8lE&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:55', 
            'documentation' => 'support/yootheme-pro/wordpress/menus#menu-locations', 
            'support' => 'support/search?tags=125&q=menu%20location'
          ], [
            'title' => 'Using the Menu Widget', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=jjcX1PE6zq4&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:53', 
            'documentation' => 'support/yootheme-pro/wordpress/menus#menu-widget', 
            'support' => 'support/search?tags=125&q=menu%20widget'
          ]], 
        'Menu Items' => [[
            'title' => 'Creating Menu Dividers', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=avfx9uy6LdM&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:40', 
            'documentation' => 'support/yootheme-pro/wordpress/menus#menu-divider', 
            'support' => 'support/search?tags=125&q=menu%20divider'
          ], [
            'title' => 'Creating Menu Headings', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=tuUhESW_U3o&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:40', 
            'documentation' => 'support/yootheme-pro/wordpress/menus#menu-heading', 
            'support' => 'support/search?tags=125&q=menu%20heading'
          ], [
            'title' => 'Creating Navbar Text Items', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=Q0gILSVvbII&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:12', 
            'documentation' => 'support/yootheme-pro/wordpress/menus#navbar-text-item', 
            'support' => 'support/search?tags=125&q=navbar%20text%20item'
          ], [
            'title' => 'Creating Accordion Menus', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=E1tLbmRNgwo&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:57', 
            'documentation' => 'support/yootheme-pro/wordpress/menus#accordion-menu', 
            'support' => 'support/search?tags=125&q=accordion%20menu'
          ]]
      ]
    ], 
    'settings' => [
      'help' => [[
          'title' => 'Using the Sidebar', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=MM3FRptp9yk&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '0:51', 
          'documentation' => 'support/yootheme-pro/wordpress/customizer#save,-cancel-and-close', 
          'support' => 'support/search?tags=125&q=customizer%20save'
        ], [
          'title' => 'Using the Contextual Help', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=EF8pQklT-Kc&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '0:39', 
          'documentation' => 'support/yootheme-pro/wordpress/customizer#contextual-help', 
          'support' => 'support/search?tags=125&q=contextual%20help'
        ], [
          'title' => 'Using the Device Preview Buttons', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=zg8H6wRX8b0&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '0:26', 
          'documentation' => 'support/yootheme-pro/wordpress/customizer#device-preview-buttons', 
          'support' => 'support/search?tags=125&q=customizer%20device%20preview'
        ], [
          'title' => 'Hide the Sidebar', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=RM4jQ7bMonE&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '0:23', 
          'documentation' => 'support/yootheme-pro/wordpress/customizer#hide-sidebar', 
          'support' => 'support/search?tags=125&q=customizer%20hide%%20sidebar'
        ]]
    ]
  ], 
  'panels' => [
    'site' => [
      'help' => [
        'Site' => [[
            'title' => 'Adding the Logo', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=Rm4viyPe-7U&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:30', 
            'documentation' => 'support/yootheme-pro/wordpress/site-and-logo#logo', 
            'support' => 'support/search?tags=125&q=logo'
          ], [
            'title' => 'Setting the Page Layout', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=t6a1Zgrf9xs&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:50', 
            'documentation' => 'support/yootheme-pro/wordpress/site-and-logo#layout', 
            'support' => 'support/search?tags=125&q=site%20layout'
          ], [
            'title' => 'Using the Toolbar', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=g0MsBQH1uC8&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:41', 
            'documentation' => 'support/yootheme-pro/wordpress/site-and-logo#toolbar', 
            'support' => 'support/search?tags=125&q=toolbar'
          ], [
            'title' => 'Displaying the Breadcrumbs', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=fKoPyd2uYpA&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:42', 
            'documentation' => 'support/yootheme-pro/wordpress/site-and-logo#breadcrumbs', 
            'support' => 'support/search?tags=125&q=breadcrumbs'
          ]], 
        'Image Field' => [[
            'title' => 'Using Images', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=VRteZRW2HNo&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:12', 
            'documentation' => 'support/yootheme-pro/wordpress/files-and-images#images', 
            'support' => 'support/search?tags=125&q=image%20field'
          ], [
            'title' => 'Using the Media Manager', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=ELnpkZcQEBE&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:26', 
            'documentation' => 'support/yootheme-pro/wordpress/files-and-images#media-manager', 
            'support' => 'support/search?tags=125&q=media%20manager'
          ], [
            'title' => 'Using the Unsplash Library', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=0cgrc7HORj0&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:49', 
            'documentation' => 'support/yootheme-pro/wordpress/files-and-images#unsplash-library', 
            'support' => 'support/search?tags=125&q=unsplash'
          ]]
      ]
    ], 
    'header' => [
      'help' => [[
          'title' => 'Setting the Header Layout', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=9TZOvChlGwA&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '3:35', 
          'documentation' => 'support/yootheme-pro/wordpress/header-and-navbar#header-layout', 
          'support' => 'support/search?tags=125&q=header%20layout'
        ], [
          'title' => 'Setting the Navbar', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=SYD7UFx5Quc&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '0:55', 
          'documentation' => 'support/yootheme-pro/wordpress/header-and-navbar#navbar', 
          'support' => 'support/search?tags=125&q=navbar'
        ], [
          'title' => 'Adding Navbar Subtitles', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=HndZgSDhl68&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '0:18', 
          'documentation' => 'support/yootheme-pro/wordpress/header-and-navbar#subtitles', 
          'support' => 'support/search?tags=125&q=navbar%20subtitles'
        ], [
          'title' => 'Using the Dropdown Menu', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=1wiUWAhp1Fo&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '1:43', 
          'documentation' => 'support/yootheme-pro/wordpress/header-and-navbar#dropdown-layout', 
          'support' => 'support/search?tags=125&q=navbar%20dropdown%20layout'
        ], [
          'title' => 'Using the Offcanvas Menu', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=6CJVGcPamRg&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '1:02', 
          'documentation' => 'support/yootheme-pro/wordpress/header-and-navbar#offcanvas-layout', 
          'support' => 'support/search?tags=125&q=navbar%20offcanvas%20layout'
        ], [
          'title' => 'Using the Modal Menu', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=M6EHBek235Y&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '0:25', 
          'documentation' => 'support/yootheme-pro/wordpress/header-and-navbar#modal-layout', 
          'support' => 'support/search?tags=125&q=navbar%20modal%20layout'
        ], [
          'title' => 'Adding the Search', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=wceRMumCttE&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '0:31', 
          'documentation' => 'support/yootheme-pro/wordpress/header-and-navbar#search', 
          'support' => 'support/search?tags=125&q=header%20search'
        ], [
          'title' => 'Adding the Social Icons', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=ItJ7UV5gcKk&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '0:52', 
          'documentation' => 'support/yootheme-pro/wordpress/header-and-navbar#social-icons', 
          'support' => 'support/search?tags=125&q=header%20social'
        ]]
    ], 
    'mobile' => [
      'help' => [[
          'title' => 'Displaying the Mobile Header', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=-OpUt2PUl3k&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '0:37', 
          'documentation' => 'support/yootheme-pro/wordpress/mobile-header#breakpoint', 
          'support' => 'support/search?tags=125&q=mobile%20header%20breakpoint'
        ], [
          'title' => 'Setting the Navbar', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=SCjRRF7vV0s&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '0:34', 
          'documentation' => 'support/yootheme-pro/wordpress/mobile-header#navbar', 
          'support' => 'support/search?tags=125&q=mobile%20header%20navbar'
        ], [
          'title' => 'Displaying the Logo and Menu Toggle', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=ibZh3_j5B0E&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '0:47', 
          'documentation' => 'support/yootheme-pro/wordpress/mobile-header#logo-and-menu-toggle', 
          'support' => 'support/search?tags=125&q=mobile%20header%20logo'
        ], [
          'title' => 'Setting the Mobile Menu Style', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=0QCYK2l9ZSI&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '0:26', 
          'documentation' => 'support/yootheme-pro/wordpress/mobile-header#menu-style', 
          'support' => 'support/search?tags=125&q=mobile%20header%20menu%20style'
        ], [
          'title' => 'Using the Offcanvas Menu Animation', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=olpHTAR7MK4&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '1:04', 
          'documentation' => 'support/yootheme-pro/wordpress/mobile-header#offcanvas', 
          'support' => 'support/search?tags=125&q=mobile%20header%20offcanvas'
        ], [
          'title' => 'Using the Modal Menu Animation', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=wAbn8A-iZj4&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '0:25', 
          'documentation' => 'support/yootheme-pro/wordpress/mobile-header#modal', 
          'support' => 'support/search?tags=125&q=mobile%20header%20modal'
        ], [
          'title' => 'Using the Dropdown Menu Animation', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=aJPKA7E6c8w&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '0:25', 
          'documentation' => 'support/yootheme-pro/wordpress/mobile-header#dropdown', 
          'support' => 'support/search?tags=125&q=mobile%20header%20dropdown'
        ]]
    ], 
    'top' => [
      'help' => [
        'Top and Bottom' => [[
            'title' => 'Setting the Top and Bottom Areas', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=fqIxFSXiulI&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:41', 
            'documentation' => 'support/yootheme-pro/wordpress/top-bottom-and-sidebar#top-and-bottom', 
            'support' => 'support/search?tags=125&q=top%20bottom%20position%20settings'
          ]], 
        'Image Field' => [[
            'title' => 'Using Images', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=VRteZRW2HNo&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:12', 
            'documentation' => 'support/yootheme-pro/wordpress/files-and-images#images', 
            'support' => 'support/search?tags=125&q=image%20field'
          ], [
            'title' => 'Using the Media Manager', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=ELnpkZcQEBE&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:26', 
            'documentation' => 'support/yootheme-pro/wordpress/files-and-images#media-manager', 
            'support' => 'support/search?tags=125&q=media%20manager'
          ], [
            'title' => 'Using the Unsplash Library', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=0cgrc7HORj0&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:49', 
            'documentation' => 'support/yootheme-pro/wordpress/files-and-images#unsplash-library', 
            'support' => 'support/search?tags=125&q=unsplash'
          ]], 
        'Builder' => [[
            'title' => 'The Area Element', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=wpV6Ll_wT_Y&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:58', 
            'documentation' => 'support/yootheme-pro/wordpress/system-elements#area-element', 
            'support' => 'support/search?tags=125&q=area%20element'
          ], [
            'title' => 'Collapsing Layouts', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=3Vqe94SZeHM&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:00', 
            'documentation' => 'support/yootheme-pro/wordpress/collapsing-layouts', 
            'support' => 'support/search?tags=125&q=collapsing'
          ]]
      ]
    ], 
    'sidebar' => [
      'help' => [
        'Sidebar' => [[
            'title' => 'Setting the Sidebar Area', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=g1exLdgmPd8&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:32', 
            'documentation' => 'support/yootheme-pro/wordpress/top-bottom-and-sidebar#sidebar', 
            'support' => 'support/search?tags=125&q=sidebar%20position%20settings'
          ]], 
        'Builder' => [[
            'title' => 'The Area Element', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=wpV6Ll_wT_Y&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:58', 
            'documentation' => 'support/yootheme-pro/wordpress/system-elements#area-element', 
            'support' => 'support/search?tags=125&q=area%20element'
          ], [
            'title' => 'Collapsing Layouts', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=3Vqe94SZeHM&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:00', 
            'documentation' => 'support/yootheme-pro/wordpress/collapsing-layouts', 
            'support' => 'support/search?tags=125&q=collapsing'
          ]]
      ]
    ], 
    'bottom' => [
      'help' => [
        'Top and Bottom' => [[
            'title' => 'Setting the Top and Bottom Areas', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=fqIxFSXiulI&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:41', 
            'documentation' => 'support/yootheme-pro/wordpress/top-bottom-and-sidebar#top-and-bottom', 
            'support' => 'support/search?tags=125&q=top%20bottom%20position%20settings'
          ]], 
        'Image Field' => [[
            'title' => 'Using Images', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=VRteZRW2HNo&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:12', 
            'documentation' => 'support/yootheme-pro/wordpress/files-and-images#images', 
            'support' => 'support/search?tags=125&q=image%20field'
          ], [
            'title' => 'Using the Media Manager', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=ELnpkZcQEBE&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:26', 
            'documentation' => 'support/yootheme-pro/wordpress/files-and-images#media-manager', 
            'support' => 'support/search?tags=125&q=media%20manager'
          ], [
            'title' => 'Using the Unsplash Library', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=0cgrc7HORj0&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:49', 
            'documentation' => 'support/yootheme-pro/wordpress/files-and-images#unsplash-library', 
            'support' => 'support/search?tags=125&q=unsplash'
          ]], 
        'Builder' => [[
            'title' => 'The Area Element', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=wpV6Ll_wT_Y&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:58', 
            'documentation' => 'support/yootheme-pro/wordpress/system-elements#area-element', 
            'support' => 'support/search?tags=125&q=area%20element'
          ], [
            'title' => 'Collapsing Layouts', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=3Vqe94SZeHM&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:00', 
            'documentation' => 'support/yootheme-pro/wordpress/collapsing-layouts', 
            'support' => 'support/search?tags=125&q=collapsing'
          ]]
      ]
    ], 
    'footer-builder' => [
      'help' => [
        'Footer Builder' => [[
            'title' => 'Using the Footer Builder', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=WXfOV_ipCsI&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:58', 
            'documentation' => 'support/yootheme-pro/wordpress/footer-builder', 
            'support' => 'support/search?tags=125&q=footer%20builder'
          ]], 
        'Images and Links' => [[
            'title' => 'Using Images', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=VRteZRW2HNo&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:12', 
            'documentation' => 'support/yootheme-pro/wordpress/files-and-images#images', 
            'support' => 'support/search?tags=125&q=image%20field'
          ], [
            'title' => 'Using Links', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=a0pbwsF86-g&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:40', 
            'documentation' => 'support/yootheme-pro/wordpress/files-and-images#links', 
            'support' => 'support/search?tags=125&q=link%20field'
          ], [
            'title' => 'Using the Media Manager', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=ELnpkZcQEBE&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:26', 
            'documentation' => 'support/yootheme-pro/wordpress/files-and-images#media-manager', 
            'support' => 'support/search?tags=125&q=media%20manager'
          ], [
            'title' => 'Using the Unsplash Library', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=0cgrc7HORj0&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:49', 
            'documentation' => 'support/yootheme-pro/wordpress/files-and-images#unsplash-library', 
            'support' => 'support/search?tags=125&q=unsplash'
          ]], 
        'Builder Widget' => [[
            'title' => 'Open the Builder Widget', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=JL7gkNxBS-c&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:13', 
            'documentation' => 'support/yootheme-pro/wordpress/builder-widget-and-module', 
            'support' => 'support/search?tags=125&q=builder%20widget'
          ], [
            'title' => 'Creating Advanced Widget Layouts', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=CErGPHexytc&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '4:19', 
            'documentation' => 'support/yootheme-pro/wordpress/builder-widget-and-module#advanced-layouts', 
            'support' => 'support/search?tags=125&q=builder%20widget'
          ]]
      ]
    ], 
    'advanced' => [
      'fields' => [
        'disable_wpautop' => [
          'label' => 'Filter', 
          'description' => 'Disable the <a href="https://developer.wordpress.org/reference/functions/wpautop/" target="_blank">wpautop</a> filter for the_content and the_excerpt.', 
          'type' => 'checkbox', 
          'text' => 'Disable wpautop'
        ], 
        'disable_emojis' => [
          'description' => 'Disable conversion of Emoji characters to images.', 
          'type' => 'checkbox', 
          'text' => 'Disable Emojis'
        ]
      ], 
      'help' => [[
          'title' => 'Lazy Loading', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=3CO52QpovTE&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '0:59', 
          'documentation' => 'support/yootheme-pro/wordpress/settings#lazy-loading', 
          'support' => 'support/search?tags=125&q=lazy%20loading'
        ], [
          'title' => 'Serving WebP Images', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=gaKGYGXxomU&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '1:46', 
          'documentation' => 'support/yootheme-pro/wordpress/settings#next-gen-images', 
          'support' => 'support/search?tags=125&q=webp'
        ]]
    ], 
    'api-key' => [
      'fields' => [
        'minimum_stability' => [
          'label' => 'Minimum Stability', 
          'description' => 'The minimum stability of the theme updates. Stable is recommended for production websites, Beta is only for testing new features and reporting issues.', 
          'type' => 'select', 
          'options' => [
            'Stable' => 'stable', 
            'Beta' => 'beta'
          ]
        ]
      ]
    ], 
    'system-post' => [
      'title' => 'Post', 
      'width' => 400, 
      'fields' => [
        'post.width' => [
          'label' => 'Width', 
          'description' => 'Set the post width. The image and content can\'t expand beyond this width.', 
          'type' => 'select', 
          'options' => [
            'XSmall' => 'xsmall', 
            'Small' => 'small', 
            'Default' => 'default', 
            'Large' => 'large', 
            'XLarge' => 'xlarge', 
            'Expand' => 'expand', 
            'None' => ''
          ]
        ], 
        'post.padding' => [
          'label' => 'Padding', 
          'description' => 'Set the vertical padding.', 
          'type' => 'select', 
          'options' => [
            'Default' => '', 
            'XSmall' => 'xsmall', 
            'Small' => 'small', 
            'Large' => 'large', 
            'XLarge' => 'xlarge'
          ]
        ], 
        'post.padding_remove' => [
          'type' => 'checkbox', 
          'text' => 'Remove top padding'
        ], 
        'post.content_width' => [
          'label' => 'Content Width', 
          'description' => 'Set an optional content width which doesn\'t affect the image.', 
          'type' => 'select', 
          'options' => [
            'Auto' => '', 
            'XSmall' => 'xsmall', 
            'Small' => 'small'
          ], 
          'enable' => 'post.width != \'xsmall\''
        ], 
        'post.image_align' => [
          'label' => 'Image Alignment', 
          'description' => 'Align the image to the top or place it between the title and the content.', 
          'type' => 'select', 
          'options' => [
            'Top' => 'top', 
            'Between' => 'between'
          ]
        ], 
        'post.image_margin' => [
          'label' => 'Image Margin', 
          'description' => 'Set the top margin if the image is aligned between the title and the content.', 
          'type' => 'select', 
          'options' => [
            'Small' => 'small', 
            'Default' => 'default', 
            'Medium' => 'medium', 
            'Large' => 'large', 
            'X-Large' => 'xlarge', 
            'None' => 'remove'
          ], 
          'enable' => 'post.image_align == \'between\''
        ], 
        'post.image_dimension' => [
          'type' => 'grid', 
          'description' => 'Setting just one value preserves the original proportions. The image will be resized and cropped automatically and where possible, high resolution images will be auto-generated.', 
          'fields' => [
            'post.image_width' => [
              'label' => 'Image Width', 
              'width' => '1-2', 
              'attrs' => [
                'placeholder' => 'auto', 
                'lazy' => true
              ]
            ], 
            'post.image_height' => [
              'label' => 'Image Height', 
              'width' => '1-2', 
              'attrs' => [
                'placeholder' => 'auto', 
                'lazy' => true
              ]
            ]
          ]
        ], 
        'post.header_align' => [
          'label' => 'Alignment', 
          'description' => 'Align the title and meta text.', 
          'type' => 'checkbox', 
          'text' => 'Center the title and meta text'
        ], 
        'post.title_margin' => [
          'label' => 'Title Margin', 
          'description' => 'Set the top margin.', 
          'type' => 'select', 
          'options' => [
            'Small' => 'small', 
            'Default' => 'default', 
            'Medium' => 'medium', 
            'Large' => 'large', 
            'X-Large' => 'xlarge', 
            'None' => 'remove'
          ]
        ], 
        'post.meta_align' => [
          'label' => 'Meta Alignment', 
          'description' => 'Position the meta text above or below the title.', 
          'type' => 'select', 
          'options' => [
            'Top' => 'top', 
            'Bottom' => 'bottom'
          ]
        ], 
        'post.meta_margin' => [
          'label' => 'Meta Margin', 
          'description' => 'Set the top margin.', 
          'type' => 'select', 
          'options' => [
            'Small' => 'small', 
            'Default' => 'default', 
            'Medium' => 'medium', 
            'Large' => 'large', 
            'X-Large' => 'xlarge', 
            'None' => 'remove'
          ]
        ], 
        'post.meta_style' => [
          'label' => 'Meta Style', 
          'description' => 'Display the meta text in a sentence or a horizontal list.', 
          'type' => 'select', 
          'options' => [
            'List' => 'list', 
            'Sentence' => 'sentence'
          ]
        ], 
        'post.content_margin' => [
          'label' => 'Content Margin', 
          'description' => 'Set the top margin.', 
          'type' => 'select', 
          'options' => [
            'Small' => 'small', 
            'Default' => 'default', 
            'Medium' => 'medium', 
            'Large' => 'large', 
            'X-Large' => 'xlarge', 
            'None' => 'remove'
          ]
        ], 
        'post.content_dropcap' => [
          'label' => 'Drop Cap', 
          'description' => 'Set a large initial letter that drops below the first line of the first paragraph.', 
          'type' => 'checkbox', 
          'text' => 'Show drop cap'
        ], 
        'post.navigation' => [
          'label' => 'Navigation', 
          'description' => 'Enable a navigation to move to the previous or next post.', 
          'type' => 'checkbox', 
          'text' => 'Show navigation'
        ], 
        'post.date' => [
          'label' => 'Display', 
          'type' => 'checkbox', 
          'text' => 'Show date'
        ], 
        'post.author' => [
          'type' => 'checkbox', 
          'text' => 'Show author'
        ], 
        'post.categories' => [
          'type' => 'checkbox', 
          'text' => 'Show categories'
        ], 
        'post.tags' => [
          'description' => 'Show system fields for single posts. This option does not apply to the blog.', 
          'type' => 'checkbox', 
          'text' => 'Show tags'
        ]
      ], 
      'help' => [
        'Post' => [[
            'title' => 'Setting the Post Layout', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=iwS-sx4aHeU&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:37', 
            'documentation' => 'support/yootheme-pro/wordpress/blog-and-post#post-layout', 
            'support' => 'support/search?tags=125&q=post'
          ], [
            'title' => 'Setting the Post Image', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=ufnIz-zxJnQ&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:54', 
            'documentation' => 'support/yootheme-pro/wordpress/blog-and-post#post-image', 
            'support' => 'support/search?tags=125&q=post'
          ], [
            'title' => 'Setting the Post Content', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=hLZP4uQOuio&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:07', 
            'documentation' => 'support/yootheme-pro/wordpress/blog-and-post#post-content', 
            'support' => 'support/search?tags=125&q=post'
          ], [
            'title' => 'Setting the Post Navigation', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=1H-cHcK1V7g&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:14', 
            'documentation' => 'support/yootheme-pro/wordpress/blog-and-post#post-navigation', 
            'support' => 'support/search?tags=125&q=post'
          ]], 
        'Post Builder' => [[
            'title' => 'Using the Post Builder', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=fHs5nAZ1L9k&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '2:37', 
            'documentation' => 'support/yootheme-pro/wordpress/pages-and-posts#posts', 
            'support' => 'support/search?tags=125&q=builder'
          ]]
      ]
    ], 
    'system-blog' => [
      'title' => 'Blog', 
      'width' => 400, 
      'fields' => [
        'blog.width' => [
          'label' => 'Width', 
          'description' => 'Set the blog width.', 
          'type' => 'select', 
          'options' => [
            'Default' => 'default', 
            'Small' => 'small', 
            'Large' => 'large', 
            'XLarge' => 'xlarge', 
            'Expand' => 'expand'
          ]
        ], 
        'blog.padding' => [
          'label' => 'Padding', 
          'description' => 'Set the vertical padding.', 
          'type' => 'select', 
          'options' => [
            'Default' => '', 
            'XSmall' => 'xsmall', 
            'Small' => 'small', 
            'Large' => 'large', 
            'XLarge' => 'xlarge'
          ]
        ], 
        'blog.column' => [
          'label' => 'Columns', 
          'type' => 'select', 
          'options' => [
            1 => 1, 
            2 => 2, 
            3 => 3, 
            4 => 4
          ]
        ], 
        'blog.grid_column_gap' => [
          'label' => 'Column Gap', 
          'description' => 'Set the size of the gap between the grid columns.', 
          'type' => 'select', 
          'default' => '', 
          'options' => [
            'Small' => 'small', 
            'Medium' => 'medium', 
            'Default' => '', 
            'Large' => 'large', 
            'None' => 'collapse'
          ], 
          'enable' => 'blog.column != \'1\''
        ], 
        'blog.grid_row_gap' => [
          'label' => 'Row Gap', 
          'description' => 'Set the size of the gap between the grid rows.', 
          'type' => 'select', 
          'default' => '', 
          'options' => [
            'Small' => 'small', 
            'Medium' => 'medium', 
            'Default' => '', 
            'Large' => 'large', 
            'None' => 'collapse'
          ]
        ], 
        'blog.grid_breakpoint' => [
          'label' => 'Breakpoint', 
          'description' => 'Set the breakpoint from which grid items will stack.', 
          'type' => 'select', 
          'options' => [
            'Small (Phone Landscape)' => 's', 
            'Medium (Tablet Landscape)' => 'm', 
            'Large (Desktop)' => 'l', 
            'X-Large (Large Screens)' => 'xl'
          ], 
          'enable' => 'blog.column != \'1\''
        ], 
        'blog.grid_masonry' => [
          'label' => 'Masonry', 
          'description' => 'The masonry effect creates a layout free of gaps even if grid items have different heights. ', 
          'type' => 'checkbox', 
          'text' => 'Enable masonry effect', 
          'enable' => 'blog.column != \'1\''
        ], 
        'blog.grid_parallax' => [
          'label' => 'Parallax', 
          'description' => 'The parallax effect moves single grid columns at different speeds while scrolling. Define the vertical parallax offset in pixels.', 
          'type' => 'range', 
          'attrs' => [
            'min' => 0, 
            'max' => 600, 
            'step' => 10
          ], 
          'enable' => 'blog.column != \'1\''
        ], 
        'blog.image_align' => [
          'label' => 'Image Alignment', 
          'description' => 'Align the image to the top or place it between the title and the content.', 
          'type' => 'select', 
          'options' => [
            'Top' => 'top', 
            'Between' => 'between'
          ]
        ], 
        'blog.image_margin' => [
          'label' => 'Image Margin', 
          'description' => 'Set the top margin if the image is aligned between the title and the content.', 
          'type' => 'select', 
          'options' => [
            'Small' => 'small', 
            'Default' => 'default', 
            'Medium' => 'medium', 
            'Large' => 'large', 
            'X-Large' => 'xlarge', 
            'None' => 'remove'
          ], 
          'enable' => 'blog.image_align == \'between\''
        ], 
        'blog.image_dimension' => [
          'type' => 'grid', 
          'description' => 'Setting just one value preserves the original proportions. The image will be resized and cropped automatically and where possible, high resolution images will be auto-generated.', 
          'fields' => [
            'blog.image_width' => [
              'label' => 'Image Width', 
              'width' => '1-2', 
              'attrs' => [
                'placeholder' => 'auto', 
                'lazy' => true
              ]
            ], 
            'blog.image_height' => [
              'label' => 'Image Height', 
              'width' => '1-2', 
              'attrs' => [
                'placeholder' => 'auto', 
                'lazy' => true
              ]
            ]
          ]
        ], 
        'blog.header_align' => [
          'label' => 'Alignment', 
          'description' => 'Align the title and meta text as well as the continue reading button.', 
          'type' => 'checkbox', 
          'text' => 'Center the title, meta text and button'
        ], 
        'blog.title_style' => [
          'label' => 'Title Style', 
          'description' => 'Title styles differ in font-size but may also come with a predefined color, size and font.', 
          'type' => 'select', 
          'options' => [
            'None' => '', 
            'H1' => 'h1', 
            'H2' => 'h2', 
            'H3' => 'h3', 
            'H4' => 'h4'
          ]
        ], 
        'blog.title_margin' => [
          'label' => 'Title Margin', 
          'description' => 'Set the top margin.', 
          'type' => 'select', 
          'options' => [
            'Small' => 'small', 
            'Default' => 'default', 
            'Medium' => 'medium', 
            'Large' => 'large', 
            'X-Large' => 'xlarge', 
            'None' => 'remove'
          ]
        ], 
        'blog.meta_margin' => [
          'label' => 'Meta Margin', 
          'description' => 'Set the top margin.', 
          'type' => 'select', 
          'options' => [
            'Small' => 'small', 
            'Default' => 'default', 
            'Medium' => 'medium', 
            'Large' => 'large', 
            'X-Large' => 'xlarge', 
            'None' => 'remove'
          ]
        ], 
        'blog.content_excerpt' => [
          'label' => 'Content', 
          'description' => 'Show the excerpt in the blog overview instead of the post text.', 
          'type' => 'checkbox', 
          'text' => 'Use excerpt'
        ], 
        'blog.content_length' => [
          'label' => 'Content Length', 
          'description' => 'Limit the content length to a number of characters. All HTML elements will be stripped.', 
          'type' => 'number'
        ], 
        'blog.content_margin' => [
          'label' => 'Content Margin', 
          'description' => 'Set the top margin.', 
          'type' => 'select', 
          'options' => [
            'Small' => 'small', 
            'Default' => 'default', 
            'Medium' => 'medium', 
            'Large' => 'large', 
            'X-Large' => 'xlarge', 
            'None' => 'remove'
          ]
        ], 
        'blog.content_align' => [
          'label' => 'Content Alignment', 
          'type' => 'checkbox', 
          'text' => 'Center the content'
        ], 
        'blog.button_style' => [
          'label' => 'Button', 
          'description' => 'Select a style for the continue reading button.', 
          'type' => 'select', 
          'options' => [
            'Default' => 'default', 
            'Primary' => 'primary', 
            'Secondary' => 'secondary', 
            'Danger' => 'danger', 
            'Text' => 'text'
          ]
        ], 
        'blog.button_margin' => [
          'label' => 'Button Margin', 
          'description' => 'Set the top margin.', 
          'type' => 'select', 
          'options' => [
            'Small' => 'small', 
            'Default' => 'default', 
            'Medium' => 'medium', 
            'Large' => 'large', 
            'X-Large' => 'xlarge', 
            'None' => 'remove'
          ]
        ], 
        'blog.navigation' => [
          'label' => 'Navigation', 
          'description' => 'Use a numeric pagination or previous/next links to move between blog pages.', 
          'type' => 'select', 
          'options' => [
            'Pagination' => 'pagination', 
            'Previous/Next' => 'previous/next'
          ]
        ], 
        'blog.date' => [
          'label' => 'Display', 
          'type' => 'checkbox', 
          'text' => 'Show date'
        ], 
        'blog.author' => [
          'type' => 'checkbox', 
          'text' => 'Show author'
        ], 
        'blog.categories' => [
          'type' => 'checkbox', 
          'text' => 'Show categories'
        ], 
        'blog.comments' => [
          'type' => 'checkbox', 
          'text' => 'Show comments count'
        ], 
        'blog.content' => [
          'type' => 'checkbox', 
          'text' => 'Show content'
        ], 
        'blog.tags' => [
          'type' => 'checkbox', 
          'text' => 'Show tags'
        ], 
        'blog.button' => [
          'type' => 'checkbox', 
          'text' => 'Show button'
        ], 
        'blog.category_title' => [
          'type' => 'checkbox', 
          'text' => 'Show archive category title', 
          'description' => 'Show system fields for the blog. This option does not apply to single posts.'
        ]
      ], 
      'help' => [
        'Blog' => [[
            'title' => 'Setting the Blog Layout', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=5O_hvqsFsLo&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:50', 
            'documentation' => 'support/yootheme-pro/wordpress/blog-and-post#blog-layout', 
            'support' => 'support/search?tags=125&q=blog'
          ], [
            'title' => 'Setting the Blog Image', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=AKD-Un1JLyU&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:55', 
            'documentation' => 'support/yootheme-pro/wordpress/blog-and-post#blog-image', 
            'support' => 'support/search?tags=125&q=blog'
          ], [
            'title' => 'Setting the Blog Content', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=zIJrMA6PiUU&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:17', 
            'documentation' => 'support/yootheme-pro/wordpress/blog-and-post#blog-content', 
            'support' => 'support/search?tags=125&q=blog'
          ], [
            'title' => 'Setting the Blog Navigation', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=Se4Ej2jEiC8&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:16', 
            'documentation' => 'support/yootheme-pro/wordpress/blog-and-post#blog-navigation', 
            'support' => 'support/search?tags=125&q=navigation'
          ], [
            'title' => 'Displaying the Excerpt', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=uZCTjGbaPzM&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:48', 
            'documentation' => 'support/yootheme-pro/wordpress/blog-and-post#excerpt', 
            'support' => 'support/search?tags=125&q=excerpt'
          ]]
      ]
    ]
  ]
];
