<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

/*
Plugin Name: Essentials YOOtheme Pro
Plugin URI: http://www.zoolanders.com/essentials-for-yootheme-pro
Description: Essential Addons for YOOtheme Pro by ZOOlanders
Author: ZOOlanders
Version: 1.2.7
Author URI: https://www.zoolanders.com
*/

defined('WPINC') or die;

define('YOOESSENTIALS_VERSION', '1.2.7');
define('YOOESSENTIALS_LEVEL', 'premium');

if (!class_exists('YooessentialsUpdater')) {
    require_once dirname(__FILE__) . '/classes/YooessentialsUpdater.php';
}

if (!class_exists('YooessentialsLoader')) {
    require_once dirname(__FILE__) . '/classes/YooessentialsLoader.php';
}

if (!class_exists('YooessentialsInstaller')) {
    require_once dirname(__FILE__) . '/classes/YooessentialsInstaller.php';
}

// load YOOtheme Pro modules
add_action('after_setup_theme', [YooessentialsLoader::class, 'load']);

// WP settings pages
add_action('admin_init', [YooessentialsLoader::class, 'settings']);
add_action('admin_menu', [YooessentialsLoader::class, 'settingsMenu']);

// register update hooks
add_filter('pre_set_site_transient_update_plugins', [YooessentialsUpdater::class, 'getUpdates'], 10, 2);
add_filter('plugins_api', [YooessentialsUpdater::class, 'checkInfo'], 10, 3);
add_filter('upgrader_pre_download', [YooessentialsUpdater::class, 'addDownloadID'], 10, 3);
add_filter('upgrader_package_options', [YooessentialsUpdater::class, 'packageOptions'], 10, 2);
add_action('upgrader_process_complete', [YooessentialsUpdater::class, 'postUpdate'], 10, 2);
add_filter('after_plugin_row_yooessentials/yooessentials.php', [YooessentialsUpdater::class, 'updateMessage'], 10, 3);

// register install/update hooks
register_activation_hook(__FILE__, [YooessentialsInstaller::class, 'activate']);
