<?php

/*
 * This file is part of Respect/Validation.
 *
 * (c) Alexandre Gomes Gaigalas <alexandre@gaigalas.net>
 *
 * For the full copyright and license information, please view the LICENSE file
 * that was distributed with this source code.
 */
declare (strict_types=1);
namespace ZOOlanders\YOOessentials\Vendor\Respect\Validation;

use ZOOlanders\YOOessentials\Vendor\Respect\Validation\Exceptions\ValidationException;
/** Interface for validation rules */
/**
 * @author Alexandre Gomes Gaigalas <alexandre@gaigalas.net>
 * @author Henrique Moody <henriquemoody@gmail.com>
 */
interface Validatable
{
    /**
     * @param mixed $input
     */
    public function assert($input) : void;
    /**
     * @param mixed $input
     */
    public function check($input) : void;
    public function getName() : ?string;
    /**
     * @param mixed $input
     * @param mixed[] $extraParameters
     */
    public function reportError($input, array $extraParameters = []) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\Exceptions\ValidationException;
    public function setName(string $name) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable;
    public function setTemplate(string $template) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable;
    /**
     * @param mixed $input
     */
    public function validate($input) : bool;
}
