<?php

/*
 * This file is part of Respect/Validation.
 *
 * (c) Alexandre Gomes Gaigalas <alexandre@gaigalas.net>
 *
 * For the full copyright and license information, please view the LICENSE file
 * that was distributed with this source code.
 */
declare (strict_types=1);
namespace ZOOlanders\YOOessentials\Vendor\Respect\Validation\Rules;

/**
 * Validates if the input is a Roman numeral.
 *
 * @author Alexander Wühr <wuehr@sc-networks.com>
 * @author Henrique Moody <henriquemoody@gmail.com>
 * @author Jean Pimentel <jeanfap@gmail.com>
 */
final class Roman extends \ZOOlanders\YOOessentials\Vendor\Respect\Validation\Rules\AbstractEnvelope
{
    public function __construct()
    {
        parent::__construct(new \ZOOlanders\YOOessentials\Vendor\Respect\Validation\Rules\Regex('/^(?=[MDCLXVI])M*(C[MD]|D?C{0,3})(X[CL]|L?X{0,3})(I[XV]|V?I{0,3})$/'));
    }
}
