<?php

/*
 * This file is part of Respect/Validation.
 *
 * (c) Alexandre Gomes Gaigalas <alexandre@gaigalas.net>
 *
 * For the full copyright and license information, please view the LICENSE file
 * that was distributed with this source code.
 */
declare (strict_types=1);
namespace ZOOlanders\YOOessentials\Vendor\Respect\Validation\Rules;

use ZOOlanders\YOOessentials\Vendor\Respect\Validation\Exceptions\AllOfException;
use function count;
/**
 * @author Alexandre Gomes Gaigalas <alexandre@gaigalas.net>
 * @author Henrique Moody <henriquemoody@gmail.com>
 */
class AllOf extends \ZOOlanders\YOOessentials\Vendor\Respect\Validation\Rules\AbstractComposite
{
    /**
     * {@inheritDoc}
     */
    public function assert($input) : void
    {
        $exceptions = $this->getAllThrownExceptions($input);
        $numRules = \count($this->getRules());
        $numExceptions = \count($exceptions);
        $summary = ['total' => $numRules, 'failed' => $numExceptions, 'passed' => $numRules - $numExceptions];
        if (!empty($exceptions)) {
            /** @var AllOfException $allOfException */
            $allOfException = $this->reportError($input, $summary);
            $allOfException->addChildren($exceptions);
            throw $allOfException;
        }
    }
    /**
     * {@inheritDoc}
     */
    public function check($input) : void
    {
        foreach ($this->getRules() as $rule) {
            $rule->check($input);
        }
    }
    /**
     * {@inheritDoc}
     */
    public function validate($input) : bool
    {
        foreach ($this->getRules() as $rule) {
            if (!$rule->validate($input)) {
                return \false;
            }
        }
        return \true;
    }
}
