<?php

/*
 * This file is part of Respect/Validation.
 *
 * (c) Alexandre Gomes Gaigalas <alexandre@gaigalas.net>
 *
 * For the full copyright and license information, please view the LICENSE file
 * that was distributed with this source code.
 */
declare (strict_types=1);
namespace ZOOlanders\YOOessentials\Vendor\Respect\Validation\Message;

use function call_user_func;
use function preg_replace_callback;
use function ZOOlanders\YOOessentials\Vendor\Respect\Stringifier\stringify;
final class Formatter
{
    /**
     * @var callable
     */
    private $translator;
    /**
     * @var ParameterStringifier
     */
    private $parameterStringifier;
    public function __construct(callable $translator, \ZOOlanders\YOOessentials\Vendor\Respect\Validation\Message\ParameterStringifier $parameterStringifier)
    {
        $this->translator = $translator;
        $this->parameterStringifier = $parameterStringifier;
    }
    /**
     * @param mixed $input
     * @param mixed[] $parameters
     */
    public function format(string $template, $input, array $parameters) : string
    {
        $parameters['name'] = $parameters['name'] ?? \ZOOlanders\YOOessentials\Vendor\Respect\Stringifier\stringify($input);
        return \preg_replace_callback('/{{(\\w+)}}/', function ($match) use($parameters) {
            if (!isset($parameters[$match[1]])) {
                return $match[0];
            }
            return $this->parameterStringifier->stringify($match[1], $parameters[$match[1]]);
        }, \call_user_func($this->translator, $template));
    }
}
