<?php

/*
 * This file is part of Respect/Validation.
 *
 * (c) Alexandre Gomes Gaigalas <alexandre@gaigalas.net>
 *
 * For the full copyright and license information, please view the LICENSE file
 * that was distributed with this source code.
 */
declare (strict_types=1);
namespace ZOOlanders\YOOessentials\Vendor\Respect\Validation\Exceptions;

/**
 * @author Danilo Correa <danilosilva87@gmail.com>
 * @author Henrique Moody <henriquemoody@gmail.com>
 * @author Ricardo Gobbo <ricardo@clicknow.com.br>
 */
final class VideoUrlException extends \ZOOlanders\YOOessentials\Vendor\Respect\Validation\Exceptions\ValidationException
{
    public const SERVICE = 'service';
    /**
     * {@inheritDoc}
     */
    protected $defaultTemplates = [self::MODE_DEFAULT => [self::STANDARD => '{{name}} must be a valid video URL', self::SERVICE => '{{name}} must be a valid {{service}} video URL'], self::MODE_NEGATIVE => [self::STANDARD => '{{name}} must not be a valid video URL', self::SERVICE => '{{name}} must not be a valid {{service}} video URL']];
    /**
     * {@inheritDoc}
     */
    protected function chooseTemplate() : string
    {
        if ($this->getParam('service')) {
            return self::SERVICE;
        }
        return self::STANDARD;
    }
}
