<?php

/*
 * This file is part of Respect/Validation.
 *
 * (c) Alexandre Gomes Gaigalas <alexandre@gaigalas.net>
 *
 * For the full copyright and license information, please view the LICENSE file
 * that was distributed with this source code.
 */
declare (strict_types=1);
namespace ZOOlanders\YOOessentials\Vendor\Respect\Validation\Exceptions;

/**
 * @author Alexandre Gomes Gaigalas <alexandre@gaigalas.net>
 * @author Bram Van der Sype <bram.vandersype@gmail.com>
 * @author Henrique Moody <henriquemoody@gmail.com>
 */
final class NotEmptyException extends \ZOOlanders\YOOessentials\Vendor\Respect\Validation\Exceptions\ValidationException
{
    public const NAMED = 'named';
    /**
     * {@inheritDoc}
     */
    protected $defaultTemplates = [self::MODE_DEFAULT => [self::STANDARD => 'The value must not be empty', self::NAMED => '{{name}} must not be empty'], self::MODE_NEGATIVE => [self::STANDARD => 'The value must be empty', self::NAMED => '{{name}} must be empty']];
    /**
     * {@inheritDoc}
     */
    protected function chooseTemplate() : string
    {
        if ($this->getParam('input') || $this->getParam('name')) {
            return self::NAMED;
        }
        return self::STANDARD;
    }
}
