<?php

/*
 * This file is part of Respect/Validation.
 *
 * (c) Alexandre Gomes Gaigalas <alexandre@gaigalas.net>
 *
 * For the full copyright and license information, please view the LICENSE file
 * that was distributed with this source code.
 */
declare (strict_types=1);
namespace ZOOlanders\YOOessentials\Vendor\Respect\Validation\Exceptions;

/**
 * @author Alexandre Gomes Gaigalas <alexandre@gaigalas.net>
 * @author Henrique Moody <henriquemoody@gmail.com>
 */
final class DateTimeException extends \ZOOlanders\YOOessentials\Vendor\Respect\Validation\Exceptions\ValidationException
{
    public const FORMAT = 'format';
    /**
     * {@inheritDoc}
     */
    protected $defaultTemplates = [self::MODE_DEFAULT => [self::STANDARD => '{{name}} must be a valid date/time', self::FORMAT => '{{name}} must be a valid date/time in the format {{sample}}'], self::MODE_NEGATIVE => [self::STANDARD => '{{name}} must not be a valid date/time', self::FORMAT => '{{name}} must not be a valid date/time in the format {{sample}}']];
    /**
     * {@inheritDoc}
     */
    protected function chooseTemplate() : string
    {
        return $this->getParam('format') ? self::FORMAT : self::STANDARD;
    }
}
