<?php

/*
 * This file is part of Respect/Validation.
 *
 * (c) Alexandre Gomes Gaigalas <alexandre@gaigalas.net>
 *
 * For the full copyright and license information, please view the LICENSE file
 * that was distributed with this source code.
 */
declare (strict_types=1);
namespace ZOOlanders\YOOessentials\Vendor\Respect\Validation\Exceptions;

/**
 * @author Alexandre Gomes Gaigalas <alexandre@gaigalas.net>
 * @author Henrique Moody <henriquemoody@gmail.com>
 */
class AllOfException extends \ZOOlanders\YOOessentials\Vendor\Respect\Validation\Exceptions\GroupedValidationException
{
    /**
     * {@inheritDoc}
     */
    protected $defaultTemplates = [self::MODE_DEFAULT => [self::NONE => 'All of the required rules must pass for {{name}}', self::SOME => 'These rules must pass for {{name}}'], self::MODE_NEGATIVE => [self::NONE => 'None of these rules must pass for {{name}}', self::SOME => 'These rules must not pass for {{name}}']];
}
