<?php

/*
 * This file is part of Respect/Validation.
 *
 * (c) Alexandre Gomes Gaigalas <alexandre@gaigalas.net>
 *
 * For the full copyright and license information, please view the LICENSE file
 * that was distributed with this source code.
 */
declare (strict_types=1);
namespace ZOOlanders\YOOessentials\Vendor\Respect\Validation;

use finfo;
use ZOOlanders\YOOessentials\Vendor\Respect\Validation\Rules\Key;
use ZOOlanders\YOOessentials\Vendor\Symfony\Component\Validator\Constraint;
use ZOOlanders\YOOessentials\Vendor\Symfony\Component\Validator\Validator\ValidatorInterface as SymfonyValidator;
use ZOOlanders\YOOessentials\Vendor\Zend\Validator\ValidatorInterface as ZendValidator;
interface ChainedValidator extends \ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable
{
    public function allOf(\ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable ...$rule) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function alnum(string ...$additionalChars) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function alpha(string ...$additionalChars) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function alwaysInvalid() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function alwaysValid() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function anyOf(\ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable ...$rule) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function arrayType() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function arrayVal() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function attribute(string $reference, ?\ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable $validator = null, bool $mandatory = \true) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function base(int $base, ?string $chars = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function base64() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param mixed $minimum
     * @param mixed $maximum
     */
    public function between($minimum, $maximum) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function bic(string $countryCode) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function boolType() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function boolVal() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function bsn() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function call(callable $callable, \ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable $rule) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function callableType() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function callback(callable $callback) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function charset(string ...$charset) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function cnh() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function cnpj() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function control(string ...$additionalChars) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function consonant(string ...$additionalChars) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param mixed $containsValue
     */
    public function contains($containsValue, bool $identical = \false) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param mixed[] $needles
     */
    public function containsAny(array $needles, bool $strictCompareArray = \false) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function countable() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function countryCode(?string $set = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function currencyCode() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function cpf() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function creditCard(?string $brand = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function date(string $format = 'Y-m-d') : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function dateTime(?string $format = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function decimal(int $decimals) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function digit(string ...$additionalChars) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function directory() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function domain(bool $tldCheck = \true) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function each(\ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable $rule) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function email() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param mixed $endValue
     */
    public function endsWith($endValue, bool $identical = \false) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param mixed $compareTo
     */
    public function equals($compareTo) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param mixed $compareTo
     */
    public function equivalent($compareTo) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function even() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function executable() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function exists() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function extension(string $extension) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function factor(int $dividend) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function falseVal() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function fibonacci() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function file() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param mixed[]|int $options
     */
    public function filterVar(int $filter, $options = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function finite() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function floatVal() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function floatType() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function graph(string ...$additionalChars) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param mixed $compareTo
     */
    public function greaterThan($compareTo) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function hexRgbColor() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function iban() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param mixed $compareTo
     */
    public function identical($compareTo) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function image(?\finfo $fileInfo = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function imei() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param mixed[]|mixed $haystack
     */
    public function in($haystack, bool $compareIdentical = \false) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function infinite() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function instance(string $instanceName) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function intVal() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function intType() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function ip(string $range = '*', ?int $options = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function isbn() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function iterableType() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function json() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function key(string $reference, ?\ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable $referenceValidator = null, bool $mandatory = \true) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function keyNested(string $reference, ?\ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable $referenceValidator = null, bool $mandatory = \true) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function keySet(\ZOOlanders\YOOessentials\Vendor\Respect\Validation\Rules\Key ...$rule) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function keyValue(string $comparedKey, string $ruleName, string $baseKey) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function languageCode(?string $set = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function leapDate(string $format) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function leapYear() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function length(?int $min = null, ?int $max = null, bool $inclusive = \true) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function lowercase() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param mixed $compareTo
     */
    public function lessThan($compareTo) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function luhn() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function macAddress() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param mixed $compareTo
     */
    public function max($compareTo) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function maxAge(int $age, ?string $format = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function mimetype(string $mimetype) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param mixed $compareTo
     */
    public function min($compareTo) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function minAge(int $age, ?string $format = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function multiple(int $multipleOf) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function negative() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function nfeAccessKey() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function nif() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function nip() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function no(bool $useLocale = \false) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function noneOf(\ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable ...$rule) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function not(\ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable $rule) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function notBlank() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function notEmoji() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function notEmpty() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function notOptional() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function noWhitespace() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function nullable(\ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable $rule) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function nullType() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function number() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function numericVal() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function objectType() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function odd() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function oneOf(\ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable ...$rule) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function optional(\ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable $rule) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function perfectSquare() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function pesel() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function phone() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function phpLabel() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function pis() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function polishIdCard() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function positive() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function postalCode(string $countryCode) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function primeNumber() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function printable(string ...$additionalChars) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function punct(string ...$additionalChars) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function readable() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function regex(string $regex) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function resourceType() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function roman() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function scalarVal() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function sf(\ZOOlanders\YOOessentials\Vendor\Symfony\Component\Validator\Constraint $constraint, ?\ZOOlanders\YOOessentials\Vendor\Symfony\Component\Validator\Validator\ValidatorInterface $validator = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function size(?string $minSize = null, ?string $maxSize = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function slug() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function sorted(string $direction) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function space(string ...$additionalChars) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param mixed $startValue
     */
    public function startsWith($startValue, bool $identical = \false) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function stringType() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function stringVal() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function subdivisionCode(string $countryCode) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param mixed[] $superset
     */
    public function subset(array $superset) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function symbolicLink() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function time(string $format = 'H:i:s') : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function tld() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function trueVal() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function type(string $type) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function unique() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function uploaded() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function uppercase() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function url() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function uuid(?int $version = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function version() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function videoUrl(?string $service = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function vowel(string ...$additionalChars) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function when(\ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable $if, \ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable $then, ?\ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validatable $else = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function writable() : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function xdigit(string ...$additionalChars) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    public function yes(bool $useLocale = \false) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
    /**
     * @param string|ZendValidator $validator
     * @param mixed[] $params
     */
    public function zend($validator, ?array $params = null) : \ZOOlanders\YOOessentials\Vendor\Respect\Validation\ChainedValidator;
}
