<?php

/**
 * Built-In BCMath Modular Exponentiation Engine
 *
 * PHP version 5 and 7
 *
 * @category  Math
 * @package   BigInteger
 * @author    Jim Wigginton <terrafrost@php.net>
 * @copyright 2017 Jim Wigginton
 * @license   http://www.opensource.org/licenses/mit-license.html  MIT License
 * @link      http://pear.php.net/package/Math_BigInteger
 */
namespace ZOOlanders\YOOessentials\Vendor\phpseclib3\Math\BigInteger\Engines\BCMath;

use ZOOlanders\YOOessentials\Vendor\phpseclib3\Math\BigInteger\Engines\BCMath;
/**
 * Built-In BCMath Modular Exponentiation Engine
 *
 * @package BCMath
 * @author  Jim Wigginton <terrafrost@php.net>
 * @access  public
 */
abstract class BuiltIn extends \ZOOlanders\YOOessentials\Vendor\phpseclib3\Math\BigInteger\Engines\BCMath
{
    /**
     * Performs modular exponentiation.
     *
     * @param BCMath $x
     * @param BCMath $e
     * @param BCMath $n
     * @return BCMath
     */
    protected static function powModHelper(\ZOOlanders\YOOessentials\Vendor\phpseclib3\Math\BigInteger\Engines\BCMath $x, \ZOOlanders\YOOessentials\Vendor\phpseclib3\Math\BigInteger\Engines\BCMath $e, \ZOOlanders\YOOessentials\Vendor\phpseclib3\Math\BigInteger\Engines\BCMath $n)
    {
        $temp = new \ZOOlanders\YOOessentials\Vendor\phpseclib3\Math\BigInteger\Engines\BCMath();
        $temp->value = \bcpowmod($x->value, $e->value, $n->value);
        return $x->normalize($temp);
    }
}
