<?php

declare (strict_types=1);
/*
 * This file is part of the league/commonmark package.
 *
 * (c) Colin O'Dell <colinodell@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace ZOOlanders\YOOessentials\Vendor\League\CommonMark\Normalizer;

/**
 * Creates URL-friendly strings based on the given string input
 */
final class SlugNormalizer implements \ZOOlanders\YOOessentials\Vendor\League\CommonMark\Normalizer\TextNormalizerInterface
{
    /**
     * {@inheritdoc}
     */
    public function normalize(string $text, $context = null) : string
    {
        // Trim whitespace
        $slug = \trim($text);
        // Convert to lowercase
        $slug = \mb_strtolower($slug);
        // Try replacing whitespace with a dash
        $slug = \preg_replace('/\\s+/u', '-', $slug) ?? $slug;
        // Try removing characters other than letters, numbers, and marks.
        $slug = \preg_replace('/[^\\p{L}\\p{Nd}\\p{Nl}\\p{M}-]+/u', '', $slug) ?? $slug;
        return $slug;
    }
}
