<?php

namespace ZOOlanders\YOOessentials\Vendor;

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
class Google_Service_Sheets_PivotGroup extends \ZOOlanders\YOOessentials\Vendor\Google_Collection
{
    protected $collection_key = 'valueMetadata';
    protected $dataSourceColumnReferenceType = 'ZOOlanders\YOOessentials\Vendor\Google_Service_Sheets_DataSourceColumnReference';
    protected $dataSourceColumnReferenceDataType = '';
    protected $groupLimitType = 'ZOOlanders\YOOessentials\Vendor\Google_Service_Sheets_PivotGroupLimit';
    protected $groupLimitDataType = '';
    protected $groupRuleType = 'ZOOlanders\YOOessentials\Vendor\Google_Service_Sheets_PivotGroupRule';
    protected $groupRuleDataType = '';
    public $label;
    public $repeatHeadings;
    public $showTotals;
    public $sortOrder;
    public $sourceColumnOffset;
    protected $valueBucketType = 'ZOOlanders\YOOessentials\Vendor\Google_Service_Sheets_PivotGroupSortValueBucket';
    protected $valueBucketDataType = '';
    protected $valueMetadataType = 'ZOOlanders\YOOessentials\Vendor\Google_Service_Sheets_PivotGroupValueMetadata';
    protected $valueMetadataDataType = 'array';
    /**
     * @param Google_Service_Sheets_DataSourceColumnReference
     */
    public function setDataSourceColumnReference(\ZOOlanders\YOOessentials\Vendor\Google_Service_Sheets_DataSourceColumnReference $dataSourceColumnReference)
    {
        $this->dataSourceColumnReference = $dataSourceColumnReference;
    }
    /**
     * @return Google_Service_Sheets_DataSourceColumnReference
     */
    public function getDataSourceColumnReference()
    {
        return $this->dataSourceColumnReference;
    }
    /**
     * @param Google_Service_Sheets_PivotGroupLimit
     */
    public function setGroupLimit(\ZOOlanders\YOOessentials\Vendor\Google_Service_Sheets_PivotGroupLimit $groupLimit)
    {
        $this->groupLimit = $groupLimit;
    }
    /**
     * @return Google_Service_Sheets_PivotGroupLimit
     */
    public function getGroupLimit()
    {
        return $this->groupLimit;
    }
    /**
     * @param Google_Service_Sheets_PivotGroupRule
     */
    public function setGroupRule(\ZOOlanders\YOOessentials\Vendor\Google_Service_Sheets_PivotGroupRule $groupRule)
    {
        $this->groupRule = $groupRule;
    }
    /**
     * @return Google_Service_Sheets_PivotGroupRule
     */
    public function getGroupRule()
    {
        return $this->groupRule;
    }
    public function setLabel($label)
    {
        $this->label = $label;
    }
    public function getLabel()
    {
        return $this->label;
    }
    public function setRepeatHeadings($repeatHeadings)
    {
        $this->repeatHeadings = $repeatHeadings;
    }
    public function getRepeatHeadings()
    {
        return $this->repeatHeadings;
    }
    public function setShowTotals($showTotals)
    {
        $this->showTotals = $showTotals;
    }
    public function getShowTotals()
    {
        return $this->showTotals;
    }
    public function setSortOrder($sortOrder)
    {
        $this->sortOrder = $sortOrder;
    }
    public function getSortOrder()
    {
        return $this->sortOrder;
    }
    public function setSourceColumnOffset($sourceColumnOffset)
    {
        $this->sourceColumnOffset = $sourceColumnOffset;
    }
    public function getSourceColumnOffset()
    {
        return $this->sourceColumnOffset;
    }
    /**
     * @param Google_Service_Sheets_PivotGroupSortValueBucket
     */
    public function setValueBucket(\ZOOlanders\YOOessentials\Vendor\Google_Service_Sheets_PivotGroupSortValueBucket $valueBucket)
    {
        $this->valueBucket = $valueBucket;
    }
    /**
     * @return Google_Service_Sheets_PivotGroupSortValueBucket
     */
    public function getValueBucket()
    {
        return $this->valueBucket;
    }
    /**
     * @param Google_Service_Sheets_PivotGroupValueMetadata[]
     */
    public function setValueMetadata($valueMetadata)
    {
        $this->valueMetadata = $valueMetadata;
    }
    /**
     * @return Google_Service_Sheets_PivotGroupValueMetadata[]
     */
    public function getValueMetadata()
    {
        return $this->valueMetadata;
    }
}
