<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Source;

use function YOOtheme\app;
use YOOtheme\Application;
use YOOtheme\Builder\Source;
use YOOtheme\Config;
use YOOtheme\Http\Request;
use YOOtheme\Http\Response;

class SchemaController
{
    public const CREATE_SCHEMA_URL = '/yooessentials/source/schema/create';

    public function __invoke(Application $app, Request $request, Response $response, SourceService $sourceService, Config $config)
    {
        $sources = $request->getParam('sources');
        $oauth = $request->getParam('oauth');

        // Temporarily override the oauth config in case the user has created new oauth connections not yet saved
        $config->set(ConnectedAccountsService::ACCOUNTS_CONFIG_KEY, $oauth);
        $config->set(SourceService::SOURCES_CONFIG_KEY, $sources);
        $app->set(Config::class, $config);

        $sourceService->setSources($sources);

        // Init source here, otherwise it will pick up the stored config, not the request-driven one
        $source = app(Source::class);

        foreach ($sourceService->providers() as $provider) {
            if ($provider && $provider instanceof SourceProviderInterface) {
                $sourceConfig = $this->sourceConfigFor($sources, $provider->config()->name);
                $provider->initSource($source, $sourceConfig);
            }
        }

        $schema = $this->extractSchema($source);

        return $response->withJson(['schema' => $schema]);
    }

    protected function extractSchema(Source $source): array
    {
        $result = $source->queryIntrospection()->toArray();

        return isset($result['data']) ? $result['data']['__schema'] : $result;
    }

    protected function sourceConfigFor(array $sources, string $type): array
    {
        return array_filter($sources, function ($source) use ($type) {
            return ($source['provider'] ?? '') === $type;
        });
    }
}
