<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Source\Providers\Instagram\Type;

class InstagramMediaType
{
    /**
     * @return array
     */
    public static function config()
    {
        return [

            'fields' => [
                'media_url' => [
                    'type' => 'String',
                    'metadata' => [
                        'label' => 'Media',
                    ],
                ],
                'media_type' => [
                    'type' => 'String',
                    'metadata' => [
                        'label' => 'Media Type',
                    ],
                ],
                'thumbnail_url' => [
                    'type' => 'String',
                    'metadata' => [
                        'label' => 'Video Thumbnail',
                    ],
                ],
                'caption' => [
                    'type' => 'String',
                    'metadata' => [
                        'label' => 'Caption',
                    ],
                ],
                'permalink' => [
                    'type' => 'String',
                    'metadata' => [
                        'label' => 'Permalink',
                    ],
                ],
                'comments_count' => [
                    'type' => 'Int',
                    'metadata' => [
                        'label' => 'Comments Count',
                    ],
                ],
                'like_count' => [
                    'type' => 'Int',
                    'metadata' => [
                        'label' => 'Like Count',
                    ],
                ],
                'timestamp' => [
                    'type' => 'String',
                    'metadata' => [
                        'label' => 'Timestamp',
                    ],
                ],
                'tags' => [
                    'type' => [
                        'listOf' => 'String',
                    ],
                    'metadata' => [
                        'label' => 'Hashtags',
                    ],
                ],
                'username' => [
                    'type' => 'String',
                    'metadata' => [
                        'label' => 'Username',
                    ],
                ],
                'user_id' => [
                    'type' => [
                        'listOf' => 'number'
                    ],
                    'metadata' => [
                        'label' => 'User Id',
                    ],
                ]
            ],

            'metadata' => [
                'type' => true,
                'label' => 'Instagram Media',
            ],

        ];
    }
}
