<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Source\Providers\Instagram;

use function YOOtheme\app;
use YOOtheme\Builder\Source;
use YOOtheme\Path;
use ZOOlanders\YOOessentials\Source\SourceProviderInterface;

class Provider implements SourceProviderInterface
{
    public function config(): object
    {
        return (object) app()->config->loadFile(Path::get('./provider.json'));
    }

    public function initSource(Source $source, array $config = []): void
    {
        foreach ($config ?? [] as $args) {
            $userId = $args['user_id'] ?? '';
            $pageId = $args['page_id'] ?? '';

            if (!$userId) {
                continue;
            }

            $name = self::getQueryName($args);
            $label = self::getTypeLabel($args);

            $source->queryType(Type\InstagramMediaQueryType::config($name, $label, $userId, $pageId));
            $source->objectType('InstagramMedia', Type\InstagramMediaType::config());
        }
    }

    public static function getQueryName(array $args): string
    {
        $id = self::getQueryId($args);

        return "instagram_{$id}_query";
    }

    public static function getQueryId(array $args): string
    {
        $createdOn = $args['_meta']['created_on'] ?? '';

        // legacy
        if (version_compare($createdOn, '1.2.4', '<=')) {
            $userId = $args['user_id'] ?? '';
            $pageId = $args['page_id'] ?? '';

            return "{$userId}{$pageId}";
        }

        return $args['id'];
    }

    public static function getTypeLabel(array $args): string
    {
        return $args['name'] ?? "Instagram - {$args['id']}";
    }
}
