<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Source\Providers\GoogleSheet;

use YOOtheme\Http\Request;
use YOOtheme\Http\Response;

class GoogleSheetController
{
    /**
     * @var string
     */
    public const TEST_URL = 'yooessentials/source/google-sheet/test';

    public function test(Request $request, Response $response)
    {
        $args = $request->getParsedBody();
        $userId = $args['user_id'] ?? null;
        $sheetId = $args['sheet_id'] ?? null;

        if (!$userId) {
            return $response->withStatus(400, 'No Account has been specified.');
        }

        if (!$sheetId) {
            return $response->withStatus(400, 'No Sheet ID has been specified.');
        }

        return $response->withStatus(200);
    }
}
