<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Source\Providers\Database\Type;

use function YOOtheme\app;
use YOOtheme\Database;
use YOOtheme\Str;

class DatabaseTableType
{
    public static function config(string $table, string $label): array
    {
        $fields = [];

        /** @var Database $db */
        $db = app(Database::class);
        $columns = $db->fetchAll('SHOW FULL COLUMNS FROM ' . $table . '');

        foreach ($columns as $column) {
            $field = $column['Field'] ?? null;
            $type = $column['Type'] ?? 'String';

            if (!$field) {
                continue;
            }

            $fields[$field] = [
                'type' => self::convertSqlTypeToSchemaType($type),
                'metadata' => [
                    'label' => Str::titleCase($field),
                    'fields' => [],
                    'filters' => self::getSchemaFiltersFromSqlType($type),
                ]
            ];
        }

        return [
            'fields' => $fields,
            'metadata' => [
                'type' => true,
                'label' => $label,
            ],
        ];
    }

    protected static function convertSqlTypeToSchemaType(string $type): string
    {
        switch ($type) {
            case 'int':
                return 'Int';
            case 'string':
            case 'String':
            case 'varchar':
            case 'text':
            case 'longtext':
            case 'mediumtext':
            case 'char':
            default:
                return 'String';
        }
    }

    protected static function getSchemaFiltersFromSqlType(string $type): array
    {
        switch ($type) {
            case 'datetime':
            case 'date':
                return ['date'];
            case 'string':
            case 'String':
            case 'varchar':
            case 'text':
            case 'longtext':
            case 'mediumtext':
            case 'char':
                return ['limit'];
        }

        return [];
    }
}
