<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Source\Providers\Database\Type;

use function YOOtheme\app;
use YOOtheme\Database;
use ZOOlanders\YOOessentials\Source\Providers\Database\Provider;

class DatabaseTableQueryType
{
    public static function config(string $name, string $label, string $type, string $table): array
    {
        return [
            'fields' => [
                $name => [
                    'type' => ['listOf' => $type],

                    'args' => [
                        'table' => [
                            'type' => 'String'
                        ],
                        'offset' => [
                            'type' => 'Int',
                        ],
                        'limit' => [
                            'type' => 'Int',
                        ]
                    ],

                    'metadata' => [
                        'group' => 'Database',
                        'label' => $label,
                        'fields' => [

                            'offset' => [
                                'label' => 'Offset',
                                'description' => 'How many rows should we skip (excluding the header)?',
                                'type' => 'number',
                                'default' => 0
                            ],

                            'limit' => [
                                'label' => 'Limit',
                                'description' => 'How many rows in total to fetch?',
                                'type' => 'number',
                                'default' => 20
                            ],

                        ],
                    ],

                    'extensions' => [
                        'call' => [
                            'func' => __CLASS__ . '::resolve',
                            'args' => [
                                'table' => $table
                            ]
                        ]
                    ],

                ],

            ],

        ];
    }

    public static function resolve($root, array $args)
    {
        /** @var Database $db */
        $db = app(Database::class);

        try {
            return $db->fetchAll(Provider::getQuery($args));
        } catch (\Exception $e) {
            return [];
        }
    }
}
