<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Source\Providers\Database;

use function YOOtheme\app;
use YOOtheme\Builder\Source;
use YOOtheme\Event;
use YOOtheme\Path;
use ZOOlanders\YOOessentials\Source\SourceProviderInterface;
use ZOOlanders\YOOessentials\Source\SourceService;

class Provider implements SourceProviderInterface
{
    public function config(): object
    {
        return (object) app()->config->loadFile(Path::get('./provider.json'));
    }

    public function initSource(Source $source, array $config = []): void
    {
        /** @var SourceService $service */
        $service = app(SourceService::class);

        foreach ($config as $args) {
            $table = $args['table'] ?? null;

            if (!$table) {
                continue;
            }

            try {
                $name = self::getQueryName($args);
                $label = self::getTypeLabel($args);
                $type = self::getTypeName($args);

                $source->queryType(Type\DatabaseTableQueryType::config($name, $label, $type, $table));
                $service->setObjectType($source, $type, Type\DatabaseTableType::config($table, $label));
            } catch (\Exception $e) {
                Event::emit('yooessentials.error', [
                    'addon' => 'source',
                    'provider' => 'database',
                    'error' => $e->getMessage()
                ]);
            }
        }
    }

    public static function getQueryName(array $args): string
    {
        $id = self::getQueryId($args);

        return "database_{$id}_query";
    }

    public static function getQueryId(array $args): string
    {
        $createdOn = $args['_meta']['created_on'] ?? '';

        // legacy
        if (version_compare($createdOn, '1.2.4', '<=')) {
            return sha1(json_encode($args));
        }

        return $args['id'];
    }

    public static function getTypeName(array $args): string
    {
        return 'database_' . sha1(json_encode([$args['table']]));
    }

    public static function getTypeLabel(array $args): string
    {
        return $args['name'] ?? "Database - {$args['id']}";
    }

    public static function getQuery(array $args)
    {
        $offset = $args['offset'] ?? 0;
        $limit = $args['limit'] ?? 20;
        $table = $args['table'] ?? null;

        if (!$table) {
            return '';
        }

        return 'SELECT * FROM ' . $table . ' LIMIT ' . (int) $offset . ',' . (int) $limit;
    }
}
