<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Source\Providers\Database;

use YOOtheme\Database;
use YOOtheme\Http\Request;
use YOOtheme\Http\Response;

class DatabaseController
{
    /**
     * @var string
     */
    public const TABLES_URL = '/yooessentials/source/database/tables';

    /**
     * @var string
     */
    public const TEST_URL = 'yooessentials/source/database/test';

    public function tables(Response $response, Database $db)
    {
        $tables = $db->fetchAll('SHOW TABLES');
        $tables = array_filter(array_map(function ($table) {
            return array_values($table)[0] ?? null;
        }, $tables));

        return $response
            ->withJson($tables)
            ->withStatus(200);
    }

    public function test(Request $request, Response $response)
    {
        $args = $request->getParsedBody();
        $table = $args['table'] ?? null;

        if (!$table) {
            return $response->withStatus(400, 'No Table has been specified.');
        }

        return $response->withStatus(200);
    }
}
