<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Source\Providers\Csv\Type;

use YOOtheme\Path;
use ZOOlanders\YOOessentials\Source\Providers\CSV\Provider;
use ZOOlanders\YOOessentials\Source\SourceService;
use ZOOlanders\YOOessentials\Vendor\League\Csv\Reader;
use ZOOlanders\YOOessentials\Vendor\League\Csv\Statement;

class CsvQueryType
{
    public static function config(string $name, string $label, string $type, Reader $csv): array
    {
        return [

            'fields' => [

                $name => [
                    'type' => ['listOf' => $type],

                    'args' => [
                        'file' => [
                            'type' => 'String'
                        ],
                        'offset' => [
                            'type' => 'Int',
                        ],
                        'limit' => [
                            'type' => 'Int',
                        ],
                        'skip_empty_records' => [
                            'type' => 'Boolean'
                        ]
                    ],

                    'metadata' => [
                        'group' => 'CSV',
                        'label' => $label,
                        'fields' => [

                            'skip_empty_records' => [
                                'text' => 'Skip Empty Records',
                                'type' => 'checkbox',
                                'default' => false
                            ],

                            'offset' => [
                                'label' => 'Offset',
                                'description' => 'How many rows should we skip (excluding the header)?',
                                'type' => 'number',
                                'default' => 0
                            ],

                            'limit' => [
                                'label' => 'Limit',
                                'description' => 'How many rows in total to fetch?',
                                'type' => 'number',
                                'default' => 20
                            ],

                        ],
                    ],

                    'extensions' => [
                        'call' => [
                            'func' => __CLASS__ . '::resolve',
                            'args' => [
                                'file' => '~/' . Path::relative('~', $csv->getPathname()),
                                'enclosure' => $csv->getEnclosure(),
                                'delimiter' => $csv->getDelimiter(),
                            ]
                        ]
                    ],

                ],

            ],

        ];
    }

    public static function resolve($root, array $args)
    {
        $offset = $args['offset'] ?? 0;
        $limit = $args['limit'] ?? 20;
        $skipEmptyRecords = $args['skip_empty'] ?? false;

        $csv = Provider::readCSV($args);

        if ($skipEmptyRecords) {
            $csv->skipEmptyRecords();
        }

        $query = (new Statement())->offset($offset)->limit($limit);
        $rows = $query->process($csv);

        $records = [];
        foreach ($rows->getRecords() as $row) {
            $data = [];
            foreach ($row as $key => $value) {
                $data[SourceService::encodeField($key)] = $value;
            }
            $records[] = $data;
        }

        return $records;
    }
}
