<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Source\Providers\Csv;

use YOOtheme\File;
use YOOtheme\Http\Request;
use YOOtheme\Http\Response;
use YOOtheme\Str;
use ZOOlanders\YOOessentials\Vendor\League\Csv\Statement;

class CsvController
{
    /**
     * @var string
     */
    public const TEST_URL = 'yooessentials/source/csv/test';

    public function test(Request $request, Response $response)
    {
        $args = $request->getParsedBody();
        $file = $args['file'] ?? null;

        if (!$file) {
            return $response->withStatus(400, 'CSV File Path is missing.');
        }

        if (!Str::startsWith($file, '~')) {
            $file = "~/$file";
        }

        if (!File::exists($file)) {
            return $response->withStatus(400, 'Invalid CSV File path.');
        }

        try {
            $csv = Provider::readCSV($args);
            $csv->skipEmptyRecords();
            $records = Statement::create()->process($csv);
        } catch (\Exception $e) {
            return $response->withStatus(400, $e->getMessage());
        }

        try {
            $csv->getHeader();
        } catch (\Exception $e) {
            return $response->withStatus(400, 'The File Headers are missing.');
        }

        if (empty($records->fetchOne(0))) {
            return $response->withStatus(400, 'The File Records are missing.');
        }

        return $response->withStatus(200);
    }
}
