<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Source;

use YOOtheme\Config;
use ZOOlanders\YOOessentials\ConfigurationRepository;

class ConnectedAccountsService
{
    public const ACCOUNTS_CONFIG_KEY = '~theme.yooessentials.oauth';

    /** @var ConnectedAccount[] */
    protected $accounts = [];
    /** @var ConfigurationRepository */
    protected $repository;
    /** @var Config */
    protected $config;

    public function __construct(Config $config, ConfigurationRepository $repository)
    {
        $this->repository = $repository;
        $this->accounts = $this->loadAccounts($config);
        $this->config = $config;
    }

    public function setAccounts(array $accounts): self
    {
        $this->accounts = $accounts;

        return $this;
    }

    /**
     * @param string|null $driver
     * @return ConnectedAccount[]
     */
    public function accounts(?string $driver = null): array
    {
        if (!$driver) {
            return $this->accounts;
        }

        return array_filter($this->accounts, function (ConnectedAccount $account) use ($driver) {
            return $account->driver === $driver;
        });
    }

    public function saveAccounts(array $accounts, bool $replace = false): void
    {
        try {
            $accounts = array_map(function ($config) {
                if ($config instanceof ConnectedAccount) {
                    return $config;
                }

                return new ConnectedAccount($config);
            }, $accounts);
        } catch (\Exception $e) {
        }

        if (!$replace) {
            $accounts = array_merge($this->accounts, $accounts);
        }

        // Clean duplicated
        $unique = [];
        /** @var ConnectedAccount $account */
        foreach ($accounts as $account) {
            $key = $account->driver . '-' . $account->id;
            $unique[$key] = $account;
        }

        $this->accounts = array_values($unique);

        $this->config->set(self::ACCOUNTS_CONFIG_KEY, array_map(function (ConnectedAccount $account) {
            return $account->toArray();
        }, $this->accounts));

        $this->repository->save($this->config);
    }

    public function loadAccounts(Config $config): array
    {
        $data = [];
        $accounts = $config->get(self::ACCOUNTS_CONFIG_KEY, []);

        $accounts = array_map(function ($config) {
            return new ConnectedAccount($config);
        }, $accounts);

        /** @var ConnectedAccount $account */
        foreach ($accounts as $account) {
            $key = ($account->driver.'-'.$account->id);
            $data[$key] = $account;
        }

        return array_values($data);
    }
}
