<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Source;

use ZOOlanders\YOOessentials\Source\Providers\Csv\CsvController;
use ZOOlanders\YOOessentials\Source\Providers\Database\DatabaseController;
use ZOOlanders\YOOessentials\Source\Providers\GoogleSheet\GoogleSheetController;
use ZOOlanders\YOOessentials\Source\Providers\Instagram\InstagramApi;
use ZOOlanders\YOOessentials\Source\Providers\Instagram\InstagramController;

return [

    'routes' => [
        ['post', SchemaController::CREATE_SCHEMA_URL, SchemaController::class],
        ['post', CsvController::TEST_URL, CsvController::class . '@test'],
        ['post', DatabaseController::TEST_URL, DatabaseController::class . '@test'],
        ['post', InstagramController::TEST_URL, InstagramController::class . '@test'],
        ['post', GoogleSheetController::TEST_URL, GoogleSheetController::class . '@test'],
        ['get', DatabaseController::TABLES_URL, DatabaseController::class . '@tables'],
        ['get', InstagramController::PAGES_URL, InstagramController::class . '@pages', ['allowed' => true]],
    ],

    'events' => [

        'source.init' => [
            SourceListener::class => ['initSource', -10],
            SourcePreviewListener::class => ['initSource', 99],
        ],

        'customizer.init' => [
            SourceListener::class => ['initCustomizer', -10],
        ]

    ],

    'services' => [
        ConnectedAccountsService::class => '',
        SourceService::class => '',
        InstagramApi::class => '',
    ],

    'loaders' => [
        'yooessentials-sources' => new SourcesLoader,
    ],

    'yooessentials-sources' => [
        Providers\Csv\Provider::class,
        Providers\GoogleSheet\Provider::class,
        Providers\Instagram\Provider::class,
        Providers\Database\Provider::class,
    ],

];
