<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Icons;

use YOOtheme\File;
use YOOtheme\Str;

class Collection
{
    /**
     * @var String
     */
    protected $name;

    /**
     * @var String
     */
    protected $title;

    /**
     * @var Array
     */
    protected $groups;

    /**
     * @var String
     */
    protected $totalIcons;

    /**
     * @var String
     */
    protected $ubication;

    /**
     * Constructor.
     */
    public function __construct(string $ubication, array $meta = null)
    {
        $this->ubication = $ubication;

        $meta = (object) ($meta ?: $this->getMetadata());

        $this->name = $meta->name ?? basename($ubication);
        $this->title = $meta->title ?? Str::titleCase($this->name);
        $this->groups = $meta->groups ?? [];
    }

    public function name()
    {
        return $this->name;
    }

    public function title()
    {
        return $this->title;
    }

    public function ubication()
    {
        return $this->ubication;
    }

    public function totalIcons()
    {
        return $this->totalIcons;
    }

    protected function isIcon($path)
    {
        return pathinfo($path, PATHINFO_EXTENSION) === 'svg';
    }

    protected function getMetadata()
    {
        $path = "{$this->ubication}.json";

        return File::exists($path) ? json_decode(File::getContents($path)) : [];
    }

    public function groups()
    {
        if (empty($this->groups)) {
            $icons = File::glob("$this->ubication/*.svg");
            $folders = File::glob("$this->ubication/*", GLOB_ONLYDIR);

            $this->groups = array_values(array_map(function ($v) {
                return basename($v);
            }, $folders));

            if (count($icons)) {
                array_unshift($this->groups, '__main');
            }
        }

        return $this->groups;
    }
}
