<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Icons;

use YOOtheme\Builder;
use ZOOlanders\YOOessentials\Addon;

return [

    'events' => [

        'customizer.init' => [
            IconsListener::class => ['initCustomizer', -10]
        ],

    ],

    'routes' => [
        ['get', '/yooessentials/icons', IconsController::class . '@getIcons'],
        ['get', '/yooessentials/icons/collections', IconsController::class . '@getCollections']
    ],

    'extend' => [

        Builder::class => function (Builder $builder, $app) {
            if (!Addon::enabled(Icons::class)) {
                return;
            }

            $builder->addTransform('prerender', new IconTransform);
        },

        Icons::class => function (Icons $icons, $app) {
            $icons->addCollectionsDir('~/media/yooessentials/icons'); // joomla specific
            $icons->addCollectionsDir('~/wp-content/yooessentials/icons'); // wordpress specific
        },

    ],

    'services' => [

        Icons::class => ''

    ]

];
