<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Form\Controller;

use YOOtheme\Http\Request;
use ZOOlanders\YOOessentials\Form\Action;
use ZOOlanders\YOOessentials\Form\FormService;
use ZOOlanders\YOOessentials\Form\Http\FormSubmissionResponse;

class SendTestEmailController
{
    public function send(Request $request, FormSubmissionResponse $response, FormService $formService)
    {
        $formId = $request->getParam('formid');
        $index = $request->getParam('index', 0);

        if (!$formId) {
            return $request->abort(400, 'Form ID not provided');
        }

        $form = $formService->loadForm($formId);

        if (!$form->hasAction(Action\EmailAction::class)) {
            return $response->withStatus(400, 'Form does not have Email Action');
        }

        $config = $form->actionConfigs(Action\EmailAction::class)[$index];
        $config = Action\EmailAction::prepareConfig($config, $response);
        $mailer = Action\EmailAction::prepareMailer($config);

        try {
            if ($mailer->send()) {
                return $response->withStatus(200);
            }

            return $response->withStatus(400, 'Cannot Send Email');
        } catch (\Exception $e) {
            return $response->withStatus(400, $e->getMessage());
        }
    }
}
