<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Form\Controller;

use RuntimeException;
use YOOtheme\Config;
use YOOtheme\File;
use YOOtheme\Http\Request;
use YOOtheme\Http\Response;
use YOOtheme\Path;
use YOOtheme\Str;
use YOOtheme\Url;
use ZipArchive;
use ZOOlanders\YOOessentials\Form\Action;
use ZOOlanders\YOOessentials\Form\FormService;

class DownloadCsvController
{
    public function download(Request $request, Response $response, FormService $formService, Config $appConfig)
    {
        $formId = $request->getParam('formid');
        $form = $formService->loadForm($formId);

        if (!$form->hasAction(Action\SaveCsvAction::class)) {
            throw new RuntimeException('This form does not have an associated Save CSV action');
        }

        $config = (object) $form->actionConfigs(Action\SaveCsvAction::class);

        if (!Str::startsWith($config->path, '~')) {
            $config->path = "~/$config->path";
        }

        $filename = trim(basename($config->file ?: $form->id(), '.csv'), ' /');
        $path = Path::resolve($config->path) . '/';
        $files = File::glob($path . $filename . '-*.csv');

        if (count($files) <= 0) {
            throw new RuntimeException('No files to download');
        }

        if (count($files) <= 1) {
            return $response->withRedirect(Url::to(array_shift($files)));
        }

        $zipFileName = $config->file ? str_replace('.' . File::getExtension($config->file), '', $config->file) : $form->id();
        $zipPath = $appConfig->get('app.tempDir') . '/' . $zipFileName . '.zip';

        $zip = new ZipArchive();
        $zip->open($zipPath, ZipArchive::CREATE | ZipArchive::OVERWRITE);
        foreach ($files as $file) {
            $zip->addFile($file, basename($file));
        }

        $zip->close();

        return $response->withRedirect(Url::to($zipPath), 303);
    }
}
