<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Form;

use YOOtheme\Container;
use ZOOlanders\YOOessentials\Addon;

class ActionLoader
{
    public function __invoke(Container $container, array $configs)
    {
        $container->extend(FormService::class, static function (FormService $formService, $app) use ($configs) {
            if (!Addon::enabled(Form::class)) {
                return;
            }

            foreach ($configs as $classes) {
                foreach ($classes as $class) {
                    $formService->addAction($class);
                }
            }
        });
    }
}
