<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Form\Action;

abstract class StandardAction
{
    /** @var string */
    protected $configKey;

    protected $config = [];

    public function __construct(array $actionConfig = [])
    {
        $this->config = $actionConfig;
    }

    public function setConfig(array $config): Action
    {
        $this->config = $config;

        return $this;
    }

    public function getConfig(): array
    {
        return $this->config;
    }

    public function panel(): array
    {
        return [];
    }
}
