<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Form\Action;

use function YOOtheme\app;
use YOOtheme\Path;
use ZOOlanders\YOOessentials\Form\Http\FormSubmissionResponse;

class MessageAction extends StandardAction implements Action
{
    protected $configKey = 'action-message';

    public function name() : string
    {
        return 'Message';
    }

    public function panel(): array
    {
        return app()->config->loadFile(Path::get('../../config/action/message.json'));
    }

    public function __invoke(FormSubmissionResponse $response, callable $next): FormSubmissionResponse
    {
        if ($response->submission()->form()->hasExternalActionUrl()) {
            return $next($response);
        }

        $message = $response->submission()->parseTags($this->getConfig()['content'] ?? '');

        return $next($response->withData([
            'message' => $message
        ]));
    }
}
