<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Form;

use function YOOtheme\App;
use YOOtheme\Arr;
use ZOOlanders\YOOessentials\Form\Http\FormSubmissionRequest;
use ZOOlanders\YOOessentials\Util\Prop;
use ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validator;

return [

    'transforms' => [

        'render' => function ($node) {

            /** @var FormSubmissionRequest $submission */
            $submission = app(FormSubmissionRequest::class);

            $controlName = $node->controls->select['name'];
            $controlProps = $node->controls->select['props'];

            $node->control = (object) [
                'name' => $controlName,
                'errors' => $submission->validator()->errors($controlName) ?? [],
                'value' => Arr::wrap($submission->data($controlName) ?? $controlProps['value']),
                'props' => $controlProps
            ];
        }

    ],

    'controls' => [

        'select' => function ($node) {
            $props = Prop::filterByPrefix($node->props, 'control_');
            $name = $props['name'] ?: "select-$node->id";
            $options = array_map(function ($child) {
                return $child->props['value'] ?? '';
            }, $node->children);

            return compact('name', 'props', 'options');
        }

    ],

    'validation' => function ($control, Validator $validator) {
        if ($control['props']['required'] ?? false) {
            $validator->notOptional();
        }

        return $validator;
    }

];
