<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Form;

use function YOOtheme\App;
use YOOtheme\Http\Response;
use YOOtheme\HttpClientInterface;
use ZOOlanders\YOOessentials\Form\Http\FormSubmissionRequest;
use ZOOlanders\YOOessentials\Util\Prop;
use ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validator;

return [

    'transforms' => [

        'render' => function ($node) {

            /** @var FormSubmissionRequest $submission */
            $submission = app(FormSubmissionRequest::class);

            $node->siteKey = $node->props['control_site_key'];

            if (!$node->siteKey) {
                return false;
            }

            $controlName = $node->controls->recaptcha['name'];
            $controlProps = $node->controls->recaptcha['props'];

            $node->control = (object) [
                'name' => $controlName,
                'errors' => $submission->validator()->errors($controlName) ?? [],
                'value' => $submission->data($controlName),
                'props' => $controlProps
            ];
        }

    ],

    'controls' => [

        'recaptcha' => function ($node) {
            $props = Prop::filterByPrefix($node->props, 'control_');
            $name = 'g-recaptcha-response';

            return compact('name', 'props');
        }

    ],

    'validation' => function ($control, Validator $validator) {
        $props = $control['props'];
        $validator->setName('Recaptcha');

        $validator->callback(function ($value) use ($props) {
            /** @var HttpClientInterface $client */
            $client = app(HttpClientInterface::class);

            /** @var Response $response */
            $response = $client->post('https://www.google.com/recaptcha/api/siteverify', [
                'secret' => $props['secret_key'] ?? '',
                'response' => $value
            ]);

            $reply = json_decode($response->getBody(), true);

            // v3 action support
            if ($props['action'] ?? false and $reply['action'] ?? false) {
                if ($props['action'] !== $reply['action']) {
                    return false;
                }
            }

            return $reply['success'] ?? false;
        });

        return $validator;
    }

];
