<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Form;

use function YOOtheme\App;
use ZOOlanders\YOOessentials\Vendor\Respect\Validation\Rules\NullType;
use ZOOlanders\YOOessentials\Vendor\Respect\Validation\Validator;
use ZOOlanders\YOOessentials\Form\Http\FormSubmissionRequest;
use ZOOlanders\YOOessentials\Util\Prop;

return [

    'transforms' => [

        'render' => function ($node) {

            /** @var FormSubmissionRequest $submission */
            $submission = app(FormSubmissionRequest::class);

            $controlName = $node->controls->radio['name'];
            $controlProps = $node->controls->radio['props'];

            $node->control = (object) [
                'name' => $controlName,
                'errors' => $submission->validator()->errors($controlName) ?? [],
                'value' => $submission->data($controlName) ?? $controlProps['value'],
                'props' => $controlProps
            ];
        }

    ],

    'controls' => [

        'radio' => function ($node) {
            $props = Prop::filterByPrefix($node->props, 'control_');
            $name = $props['name'] ?: "radio-$node->id";
            $options = array_map(function ($child) {
                return $child->props['value'];
            }, $node->children);

            return compact('name', 'props', 'options');
        }

    ],

    'validation' => function ($control, Validator $validator, $submission) {
        if ($control['props']['required'] ?? false) {
            $validator->not(new NullType);
        }

        return $validator;
    }

];
