<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Form;

use function YOOtheme\App;
use YOOtheme\Metadata;
use YOOtheme\Url;
use ZOOlanders\YOOessentials\Form\Http\FormSubmissionRequest;

return [

    'transforms' => [

        'render' => function ($node) {

            /** @var FormSubmissionRequest $submission */
            $submission = app(FormSubmissionRequest::class);

            /** @var Metadata $submission */
            $metadata = app(Metadata::class);

            /** @var FormService $formService */
            $formService = app(FormService::class);

            $form = $formService->loadForm($node->id);
            $config = $form->config();
            $hasExternalActionUrl = $form->hasExternalActionUrl();

            $submitUrl = Url::route(FormSubmissionRequest::SUBMIT_URL);

            $node->validateAction = $hasExternalActionUrl ? $submitUrl : false;
            $node->action = $hasExternalActionUrl ? $config['action_url'] : $submitUrl;
            $node->method = $hasExternalActionUrl ? $config['action_method'] : 'POST';
            $node->csrf = $submission->csrfFormToken;

            $metadata->set('script:yooessentials-form', ['src' => '~yooessentials_url/modules/form/assets/form.min.js', 'defer' => true]);
        }

    ],

];
