<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Form;

use function YOOtheme\app;
use YOOtheme\Config;
use YOOtheme\Str;

$config = app(Config::class);
$formService = app(FormService::class);

$panels = [];
$actionsOptions = [];

// set actions options
foreach ($formService->actions() as $class => $action) {
    $name = Str::upperFirst($action->name());

    $actionsOptions[$class] = [
        'title' => 'name',
        'titleFallback' => $name,
        'button' => $name,
        'panel' => $class
    ];

    $panels[$class] = $action->panel();
}

return [
    'title' => 'Form',
    'width' => 500,
    'fields' => [
        'yooessentials_form.html5validation' => [
            'text' => 'Enable HTML 5 Validation',
            'description' => 'If disabled only the Ajax/PHP based validation will be processed.',
            'type' => 'checkbox',
            'default' => true
        ],
        'yooessentials_form.after_submit_actions' => [
            'label' => 'After Submit Actions',
            'button' => 'Add Action',
            'options' => $actionsOptions,
            'emptyMsg' => 'No actions yet',
            'type' => 'yooessentials-settings-panels',
            'description' => 'Set the actions to execute after a form has been successfully submited.',
        ],
        'yooessentials_form.override_action_url' => [
            'label' => 'Submission',
            'text' => 'Override Submission Action',
            'type' => 'checkbox',
            'description' => 'Submit the form to a custom URL and method, useful for 3rd party form integrations.',
            'default' => false
        ],
        'yooessentials_form.action_url' => [
            'label' => 'Action URL',
            'enable' => 'yooessentials_form.override_action_url'
        ],
        'yooessentials_form.action_method' => [
            'label' => 'Action Method',
            'type' => 'select',
            'options' => [
                'GET' => 'GET',
                'POST' => 'POST'
            ],
            'default' => 'POST',
            'enable' => 'yooessentials_form.override_action_url'
        ]
    ],
    'fieldset' => [
        'default' => [
            'type' => 'tabs',
            'fields' => [
                [
                    'title' => 'Actions',
                    'fields' => [
                        'yooessentials_form.after_submit_actions'
                    ]
                ],
                [
                    'title' => 'Settings',
                    'fields' => [
                        'yooessentials_form.html5validation',
                        'yooessentials_form.override_action_url',
                        [
                            'name' => '_override_action',
                            'type' => 'grid',
                            'width' => '1-2',
                            'fields' => [
                                'yooessentials_form.action_url',
                                'yooessentials_form.action_method'
                            ]
                        ]
                    ]
                ]
            ]
        ]
    ],
    'panels' => $panels
];
