<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Util;

abstract class File
{
    /**
     * @param mixed $size
     */
    public static function toBytes($size): float
    {
        $value = $size;
        $units = ['b', 'kb', 'mb', 'gb', 'tb', 'pb', 'eb', 'zb', 'yb'];

        foreach ($units as $exponent => $unit) {
            if (!preg_match('/^(\d+(.\d+)?)' . $unit . '$/i', (string) $size, $matches)) {
                continue;
            }
            $value = $matches[1] * 1024 ** $exponent;

            break;
        }

        return (float) $value;
    }

    /**
     * Get the next available file name under a certain path
     *
     * @param string $path
     */
    public static function getUniqueFilepath($path) : string
    {
        $count = 0;

        while (\YOOtheme\File::exists($path)) {
            if ($p = '/_(\d+)(\.[^\/]+)$/' and preg_match($p, $path, $matches)) {
                $count = (int) $matches[1];
                $path = preg_replace($p, '\2', $path);
            }

            $count++;
            $path = preg_replace('/([^\/]+)(\.[^\/]+)$/', '\1_' . $count . '\2', $path);
        }

        return $path;
    }
}
