<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials;

use YOOtheme\Builder\UpdateTransform as Transform;

class UpdateTransform extends Transform
{
    /**
     * Transform callback.
     *
     * @param object $node
     * @param array  $params
     */
    public function __invoke($node, array &$params)
    {
        if (isset($node->transient)) {
            return;
        }

        if (isset($node->yooessentialsVersion)) {
            $params['yooessentialsVersion'] = $node->yooessentialsVersion;
        } elseif (empty($params['yooessentialsVersion'])) {
            $params['yooessentialsVersion'] = '1.0.0';
        }

        if ($node->type === 'layout') {
            $node->yooessentialsVersion = $this->version;
        } else {
            unset($node->yooessentialsVersion);
        }

        /**
         * @var $type
         * @var $version
         */
        extract($params);

        $version = $yooessentialsVersion;
        $type->updates = $type->yooessentialsUpdates;

        // check node version
        if (version_compare($version, $this->version, '>=')) {
            return;
        }

        // apply update callbacks
        foreach ($this->resolveUpdates($type, $version) as $update) {
            $update($node, $params);
        }
    }
}
