<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials;

interface Mailer
{
    public function addRecipient(string $recipient, string $name = ''): self;

    public function addCc(string $cc, string $name = ''): self;

    public function addBcc(string $bcc, string $name = ''): self;

    public function addReplyTo(string $replyTo, string $name = ''): self;

    public function setFrom(string $from, string $name = ''): self;

    public function setSubject(string $subject): self;

    public function setBody(string $body): self;

    public function isHtml(bool $isHtml): self;

    public function addAttachment(string $filePath): self;

    public function send(): bool;
}
