<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials;

use YOOtheme\Arr;
use YOOtheme\Config;
use YOOtheme\Metadata;

class ErrorListener
{
    public static function debug(Metadata $metadata, Config $config, $error)
    {
        if ($config('app.isCustomizer') || $config('app.debug')) {
            $allErrors = [];
            $previousErrors = $metadata->get('script:yooessentials-errors');

            if ($previousErrors) {
                $allErrors = $previousErrors;
            }

            $errors = $allErrors + [Arr::wrap($error)];

            $metadata->set('script:yooessentials-errors', join("\n", array_map(function ($error) {
                $error = json_encode($error);

                return "console.warn($error);";
            }, $errors)));

            return false;
        }
    }
}
