<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials;

use YOOtheme\Config;
use YOOtheme\Metadata;
use YOOtheme\Path;
use YOOtheme\Str;

class CoreListener
{
    public static function initCustomizer(Metadata $metadata, Config $config)
    {
        // add config
        $config->addFile('customizer', Path::get('../config/customizer.json'));

        // todo
        // $config->addFile('yooessentials.chart.fields', Path::get('../config/fields.json'));

        // add builder core assets
        $metadata->set('script:yooessentials-customizer-core', ['src' => '~yooessentials_url/modules/core/assets/customizer.min.js', 'defer' => true]);
    }

    public static function loadMetadata(Config $config, $meta)
    {
        if (Str::contains($meta->name, ':yooessentials')) {
            $version = $config('yooessentials.version');
            $build = $config('yooessentials.build');
            $meta->version = $version . ($build ? "-$build" : '');
        }

        return $meta;
    }
}
