<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Wordpress;

use YOOtheme\Application;
use YOOtheme\Str;

class Platform
{
    const NONCE_NAME = '_wpnonce_yooessentials';

    /**
     * Init Session when needed
     *
     * @param Application $app
     */
    public static function initSession(\ZOOlanders\YOOessentials\Session $session)
    {
        $session->start();
    }

    /**
     * Handle application routes.
     *
     * @param Application $app
     */
    public static function handleRoute(Application $app)
    {
        if (isset($__GET['p']) && Str::startsWith($__GET['p'], '/yooessentials/')) {
            $app->run();
            exit;
        }
    }

    /**
     * Prints the HTML form token used for CSRF validation
     */
    public static function printCsrfFormToken()
    {
        return wp_nonce_field(-1, self::NONCE_NAME, false, false);
    }
}
