<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials;

return [

    'config' => function () {
        return [
            'yooessentials' => [
                'timezone' => \wp_timezone()
            ]
        ];
    },

    'actions' => [

        'plugins_loaded' => [
            Wordpress\Platform::class => [
                'initSession',
                -10
            ],
        ],

        'wp_loaded' => [
            Wordpress\Platform::class => [
                'handleRoute',
                -10
            ],
        ]

    ],

    'events' => [

        'app.request' => [
            Wordpress\CsrfTokenMiddleware::class => [
                '@handle',
                20
            ],
        ]

    ],

    'extend' => [

        Form\Http\FormSubmissionRequest::class => function (Form\Http\FormSubmissionRequest $submission) {
            $submission->csrfFormToken = Wordpress\Platform::printCsrfFormToken();
        },

    ],

    'services' => [

        Session::class => Wordpress\Session::class,
        ConfigurationRepository::class => Wordpress\ConfigurationRepository::class,
        Mailer::class => [
            'class' => Wordpress\Mailer::class,
            'shared' => false
        ]
    ],

];
