<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

$class_map = array_merge(
    // Core ZOOlanders classes
    include __DIR__ . '/vendor/composer/autoload_classmap.php',
    // Third-party classes.
    include __DIR__ . '/vendor/vendor/composer/autoload_classmap.php'
);

spl_autoload_register(
    function ($class) use ($class_map) {
        if (isset($class_map[$class])) {
            require_once $class_map[$class];

            return true;
        }
    },
    true,
    true
);

// Third-party files.
$files = require __DIR__ . '/vendor/vendor/autoload_files.php';
foreach ($files as $file_identifier => $file) {
    require_once $file;
}
