<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Access\Rule;

use DateTime;

class DatetimeRule extends TimeRule
{
    public function name() : string
    {
        return 'Datetime';
    }

    public function namespace() : string
    {
        return 'yooessentials_access_datetime';
    }

    public function description() : string
    {
        return 'Validates if the current date & time are in the specified range.';
    }

    public function resolve($props, $node) : bool
    {
        $now = $this->now();
        $publishUpDate = trim($props->publish_up_date ?? '');
        $publishDownDate = trim($props->publish_down_date ?? '');
        $publishUpTime = trim($props->publish_up_time ?? '');
        $publishDownTime = trim($props->publish_down_time ?? '');

        $publishUp = trim("$publishUpDate $publishUpTime");
        $publishDown = trim("$publishDownDate $publishDownTime");

        try {
            $publishUp = $publishUp ? new DateTime($publishUp, $this->tz) : null;
            $publishDown = $publishDown ? new DateTime($publishDown, $this->tz) : null;
        } catch (\Exception $e) {
            return true;
        }

        if ($publishUp and (int) $publishUp->format('U') > (int) $now->format('U')) {
            return false;
        }

        if ($publishDown and (int) $publishDown->format('U') < (int) $now->format('U')) {
            return false;
        }

        return true;
    }

    public function fields() : array
    {
        return [
            '_date' => [
                'type' => 'grid',
                'width' => '1-2',
                'fields' => [
                    "{$this->namespace()}.publish_up_date" => [
                        'label' => 'From Date',
                        'attrs' => [
                            'type' => 'date',
                            'placeholder' => 'Y-m-d'
                        ]
                    ],
                    "{$this->namespace()}.publish_up_time" => [
                        'label' => 'and/or Time',
                        'attrs' => [
                            'type' => 'time',
                            'placeholder' => 'H:i'
                        ]
                    ]
                ]
            ],
            '_time' => [
                'description' => 'Timezone from Site configuration is automatically applied.',
                'type' => 'grid',
                'width' => '1-2',
                'fields' => [
                    "{$this->namespace()}.publish_down_date" => [
                        'label' => 'To Date',
                        'attrs' => [
                            'type' => 'date',
                            'placeholder' => 'Y-m-d'
                        ]
                    ],
                    "{$this->namespace()}.publish_down_time" => [
                        'label' => 'and/or Time',
                        'attrs' => [
                            'type' => 'time',
                            'placeholder' => 'H:i'
                        ]
                    ]
                ]
            ]
        ];
    }
}
