<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Access;

interface AccessRule
{
    public function name() : string;

    public function group() : string;

    public function namespace() : string;

    public function description() : string;

    public function fields() : array;

    /**
     * @param \stdClass $props The settings values from the rule fields
     * @param \stdClass $node The current element node being evaluated
     */
    public function resolve($props, $node) : bool;
}
