<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Access;

use YOOtheme\Arr;
use YOOtheme\Config;
use YOOtheme\Metadata;
use YOOtheme\Path;
use ZOOlanders\YOOessentials\Addon;

class AccessListener
{
    public static function initCustomizer(Config $config, Access $access, Metadata $metadata)
    {
        $config->addFile('customizer', Path::get('../config/customizer.json'));

        if (!Addon::enabled(Access::class)) {
            return;
        }

        $config->addFile('customizer.panels.yooessentials-access', Path::get('../config/conditions.php'));
        $metadata->set('script:yooessentials-customizer-access', ['src' => '~yooessentials_url/modules/access/assets/customizer.min.js', 'defer' => true]);
        $metadata->set('style:yooessentials-customizer-access', ['href' => '~yooessentials_url/modules/access/assets/customizer.min.css', 'defer' => true]);
    }

    public static function builderType(Access $access, $type)
    {
        if (!Addon::enabled(Access::class)) {
            return $type;
        }

        // make sure the main fieldset is set
        if (!Arr::has($type, 'fieldset.default')) {
            return $type;
        }

        $tabs = array_reduce($type['fieldset']['default']['fields'], function ($carry, $v) {
            return array_merge($carry, [$v['title'] ?? null]);
        }, []);

        if (($index = array_search('Advanced', $tabs)) === false) {
            return $type;
        }

        $accessPanelButton = [
            'name' => '_yooessentials_access',
            'label' => 'Access',
            'text' => 'Conditions',
            'type' => 'button-panel',
            'panel' => 'yooessentials-access',
            'description' => 'Set a condition to display the element depending on the date, user, language, and others.'
        ];

        // set button right after status field
        Arr::splice($type['fieldset']['default']['fields'][$index]['fields'], 2, 0, [$accessPanelButton]);

        return $type;
    }
}
