<?php
/**
 * @package   Essentials YOOtheme Pro 1.2.7
 * @author    ZOOlanders https://www.zoolanders.com
 * @copyright Copyright (C) Joolanders, SL
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace ZOOlanders\YOOessentials\Access;

use function YOOtheme\app;
use YOOtheme\Arr;

class Access
{
    /**
     * @var array
     */
    protected $rules = [];

    /**
     * Registers a rule.
     *
     * @return $this
     */
    public function addRule($rule)
    {
        if (!isset($this->rules[$rule])) {
            $this->rules[$rule] = app($rule);
        }

        return $this;
    }

    /**
     * Returns all rules.
     *
     * @return $rules
     */
    public function getRules()
    {
        return array_values($this->rules);
    }

    /**
     * Resolves node rendering
     *
     * @return Boolean
     */
    public function resolveNode($node)
    {
        return Arr::every($this->rules, function ($rule) use ($node) {
            $props = (object) ($node->props[$rule->namespace()] ?? []);

            if (!($props->state ?? false)) {
                return true;
            }

            return $rule->resolve($props, $node);
        });
    }
}
